﻿<?xml version="1.0" encoding="utf-8"?>
<!-- Antenna House : AH Formatter Sample 
【発行】アンテナハウス株式会社
【作成日】2016/11/15（ver.1）
【著作権の扱い】CC-BY(本サンプル集を複製または改変し、頒布や実演を行う際は著作権者の表示をしてください)
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions">
  <xsl:output method="xml" encoding="UTF-8" />
  <xsl:param name="page-width" select="'210mm'" />
  <xsl:param name="page-height" select="'297mm'" />
  <xsl:param name="margin-top" select="'2cm'" />
  <xsl:param name="margin-bottom" select="'2cm'" />
  <xsl:param name="margin-outside" select="'2cm'" />
  <xsl:param name="margin-inside" select="'2.5cm'" />
  <xsl:param name="font-family" select="'serif'" />
  <xsl:param name="font-size" select="'10pt'" />
  <xsl:param name="line-height" select="1.7" />
  <xsl:param name="column-count" select="1" />
  <xsl:param name="column-gap" select="'20pt'" />
  <xsl:param name="new-chapter" select="'new-recto'" />
  <xsl:param name="chapter-font-family" select="'sans-serif'" />
  <xsl:param name="chapter-font-size" select="'2rem'" />
  <xsl:param name="chapter-font-weight" select="'bold'" />
  <xsl:param name="chapter-start-indent" select="'0rem'" />
  <xsl:param name="chapter-line-height" select="4" />
  <xsl:param name="chapter-span" select="'all'" />
  <xsl:param name="section-font-family" select="'sans-serif'" />
  <xsl:param name="section-font-size" select="'1.5rem'" />
  <xsl:param name="section-font-weight" select="'bold'" />
  <xsl:param name="section-start-indent" select="'0rem'" />
  <xsl:param name="section-line-height" select="3" />
  <xsl:param name="section-span" select="'none'" />
  <xsl:param name="subsection-font-family" select="'sans-serif'" />
  <xsl:param name="subsection-font-size" select="'1.17rem'" />
  <xsl:param name="subsection-font-weight" select="'bold'" />
  <xsl:param name="subsection-start-indent" select="'0rem'" />
  <xsl:param name="subsection-line-height" select="2" />
  <xsl:param name="subsection-span" select="'none'" />
  <xsl:param name="list-start-distance" select="'2em'" />
  <xsl:param name="list-label-separation" select="'0.5em'" />
  <xsl:param name="ul-label-font-family">sans-serif</xsl:param>
  <xsl:param name="ul-label-font-size">1rem</xsl:param>
  <xsl:param name="ul-label-font-weight">normal</xsl:param>
  <xsl:param name="ul-label-font-style">normal</xsl:param>
  <xsl:param name="ol-label-font-family">sans-serif</xsl:param>
  <xsl:param name="ol-label-font-size">1rem</xsl:param>
  <xsl:param name="ol-label-font-weight">normal</xsl:param>
  <xsl:param name="ol-label-font-style">normal</xsl:param>
  <xsl:param name="figure-title-font-family" select="'sans-serif'" />
  <xsl:param name="figure-title-font-size" select="'0.8em'" />
  <xsl:param name="table-border" select="'solid 2pt'" />
  <xsl:param name="cell-border" select="'solid 1pt'" />
  <xsl:param name="cell-padding" select="'0.2em'" />
  <xsl:param name="table-title-font-family" select="'sans-serif'" />
  <xsl:param name="table-title-font-size" select="'0.8em'" />
  <xsl:attribute-set name="table">
    <xsl:attribute name="border-collapse">collapse</xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$table-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="th">
    <xsl:attribute name="font-weight">bold</xsl:attribute>
    <xsl:attribute name="text-align">center</xsl:attribute>
    <xsl:attribute name="padding">
      <xsl:value-of select="$cell-padding" />
    </xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$cell-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="td">
    <xsl:attribute name="font-weight">normal</xsl:attribute>
    <xsl:attribute name="text-align">start</xsl:attribute>
    <xsl:attribute name="padding">
      <xsl:value-of select="$cell-padding" />
    </xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$cell-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="figure">
    <xsl:attribute name="line-height">1</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="p">
    <xsl:attribute name="text-align">justify</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="pre">
    <xsl:attribute name="font-family">monospace</xsl:attribute>
    <xsl:attribute name="white-space">pre</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="chapter"></xsl:attribute-set>
  <xsl:attribute-set name="section"></xsl:attribute-set>
  <xsl:attribute-set name="subsection"></xsl:attribute-set>
  <xsl:attribute-set name="tobira">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
    <xsl:attribute name="font-size">40pt</xsl:attribute>
    <xsl:attribute name="text-align">center</xsl:attribute>
    <xsl:attribute name="line-height">2.5</xsl:attribute>
    <xsl:attribute name="space-before">2em</xsl:attribute>
    <xsl:attribute name="space-before.conditionality">retain</xsl:attribute>
    <xsl:attribute name="border-before-style">solid</xsl:attribute>
    <xsl:attribute name="border-after-style">solid</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="list"></xsl:attribute-set>
  <xsl:attribute-set name="a"></xsl:attribute-set>
  <xsl:attribute-set name="list-item"></xsl:attribute-set>
  <xsl:template match="doc">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions" font-family="{$font-family}" font-size="{$font-size}" line-height="{$line-height}">
      <xsl:call-template name="process-common-attributes" />
      <fo:layout-master-set>
        <fo:simple-page-master master-name="left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body column-count="{$column-count}" column-gap="{$column-gap}" margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body column-count="{$column-count}" column-gap="{$column-gap}" margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="tobira" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" />
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="main">
          <fo:repeatable-page-master-alternatives>
            <fo:conditional-page-master-reference master-reference="right" odd-or-even="odd" />
            <fo:conditional-page-master-reference master-reference="left" odd-or-even="even" />
          </fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
      </fo:layout-master-set>
      <xsl:apply-templates select="body" />
    </fo:root>
  </xsl:template>
  <xsl:template match="body">
    <xsl:choose>
      <xsl:when test="chapter">
        <xsl:apply-templates select="chapter" />
      </xsl:when>
      <xsl:otherwise>
        <fo:page-sequence master-reference="main">
          <fo:flow flow-name="xsl-region-body">
            <xsl:call-template name="process-common-attributes" />
            <xsl:call-template name="apply-blocks" />
          </fo:flow>
        </fo:page-sequence>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="p">
    <fo:block>
      <xsl:apply-templates />
    </fo:block>
  </xsl:template>
  <xsl:template match="chapter">
    <xsl:variable name="make-tobira" select="$new-chapter='han-tobira'        or $new-chapter='naka-tobira'" />
    <xsl:if test="$make-tobira">
      <xsl:call-template name="make-tobira">
        <xsl:with-param name="title" select="title[1]" />
      </xsl:call-template>
    </xsl:if>
    <fo:page-sequence master-reference="main">
      <xsl:if test="$new-chapter='new-recto' or $new-chapter='naka-tobira'      or ($new-chapter='han-tobira' and not(title))">
        <xsl:attribute name="initial-page-number">auto-odd</xsl:attribute>
      </xsl:if>
      <fo:flow flow-name="xsl-region-body">
        <fo:block xsl:use-attribute-sets="chapter">
          <xsl:if test="not($make-tobira)">
            <xsl:call-template name="process-common-attributes" />
          </xsl:if>
          <xsl:if test="not($new-chapter='han-tobira' or $new-chapter='naka-tobira') and *[1][self::title]">
            <xsl:call-template name="make-title">
              <xsl:with-param name="title" select="title[1]" />
            </xsl:call-template>
          </xsl:if>
          <xsl:call-template name="apply-blocks">
            <xsl:with-param name="extra-blocks" select="section" />
          </xsl:call-template>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>
  <xsl:template name="process-common-attributes">
    <xsl:copy-of select="@id" />
    <xsl:copy-of select="@xml:lang" />
  </xsl:template>
  <xsl:template match="section">
    <fo:block xsl:use-attribute-sets="section">
      <xsl:call-template name="process-common-attributes" />
      <xsl:if test="*[1][self::title]">
        <xsl:call-template name="make-title">
          <xsl:with-param name="title" select="title[1]" />
        </xsl:call-template>
      </xsl:if>
      <xsl:apply-templates select="subsection | p | pre | ul | ol | figure | table" />
    </fo:block>
  </xsl:template>
  <xsl:template match="subsection">
    <fo:block xsl:use-attribute-sets="subsection">
      <xsl:call-template name="process-common-attributes" />
      <xsl:if test="*[1][self::title]">
        <xsl:call-template name="make-title">
          <xsl:with-param name="title" select="title[1]" />
        </xsl:call-template>
      </xsl:if>
      <xsl:call-template name="apply-blocks" />
    </fo:block>
  </xsl:template>
  <xsl:template name="make-tobira">
    <xsl:param name="title" select="/.." />
    <xsl:if test="title">
      <fo:page-sequence master-reference="tobira" initial-page-number="auto-odd">
        <fo:flow flow-name="xsl-region-body">
          <xsl:call-template name="process-common-attributes" />
          <fo:block-container xsl:use-attribute-sets="tobira">
            <xsl:call-template name="make-title">
              <xsl:with-param name="type" select="'tobira'" />
              <xsl:with-param name="title" select="title[1]" />
            </xsl:call-template>
          </fo:block-container>
        </fo:flow>
      </fo:page-sequence>
    </xsl:if>
  </xsl:template>
  <xsl:template name="make-title">
    <xsl:param name="title" select="/.." />
    <xsl:param name="type" />
    <xsl:choose>
      <xsl:when test="self::chapter">
        <fo:block>
          <xsl:if test="$type!='tobira'">
            <xsl:attribute name="keep-with-next">always</xsl:attribute>
            <xsl:attribute name="font-family">
              <xsl:value-of select="$chapter-font-family" />
            </xsl:attribute>
            <xsl:attribute name="font-size">
              <xsl:value-of select="$chapter-font-size" />
            </xsl:attribute>
            <xsl:attribute name="font-weight">
              <xsl:value-of select="$chapter-font-weight" />
            </xsl:attribute>
            <xsl:attribute name="start-indent">
              <xsl:value-of select="$chapter-start-indent" />
            </xsl:attribute>
            <xsl:attribute name="line-height">
              <xsl:value-of select="$chapter-line-height" />
            </xsl:attribute>
            <xsl:attribute name="span">
              <xsl:value-of select="$chapter-span" />
            </xsl:attribute>
          </xsl:if>
          <xsl:apply-templates select="$title" />
        </fo:block>
      </xsl:when>
      <xsl:when test="self::section">
        <fo:block keep-with-next="always" font-family="{$section-font-family}" font-size="{$section-font-size}" font-weight="{$section-font-weight}" start-indent="{$section-start-indent}" line-height="{$section-line-height}" span="{$section-span}">
          <xsl:apply-templates select="$title" />
        </fo:block>
      </xsl:when>
      <xsl:when test="self::subsection">
        <fo:block keep-with-next="always" font-family="{$subsection-font-family}" font-size="{$subsection-font-size}" font-weight="{$subsection-font-weight}" start-indent="{$subsection-start-indent}" line-height="{$subsection-line-height}" span="{$subsection-span}">
          <xsl:apply-templates select="$title" />
        </fo:block>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="title">
    <fo:inline>
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template name="apply-blocks">
    <xsl:param name="extra-blocks" select="/.." />
    <xsl:apply-templates select="$extra-blocks | p | pre | ul | ol | figure | table" />
  </xsl:template>
  <xsl:template name="apply-inlines">
    <xsl:apply-templates select="a | i | b | u | img | citation | index | text()" />
  </xsl:template>
  <xsl:template match="p">
    <fo:block xsl:use-attribute-sets="p">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-blocks-and-inlines" />
    </fo:block>
  </xsl:template>
  <xsl:template match="pre">
    <fo:block xsl:use-attribute-sets="pre">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-blocks-and-inlines" />
    </fo:block>
  </xsl:template>
  <xsl:template name="apply-blocks-and-inlines">
    <xsl:apply-templates select="p | pre | ul | ol | figure | table | a | i | b | u | img | citation | index | text()" />
  </xsl:template>
  <xsl:template match="a">
    <fo:basic-link xsl:use-attribute-sets="a">
      <xsl:call-template name="process-common-attributes" />
      <xsl:choose>
        <xsl:when test="starts-with(@href,'#')">
          <xsl:attribute name="internal-destination">
            <xsl:value-of select="substring-after(@href,'#')" />
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="external-destination">
            <xsl:value-of select="@href" />
          </xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="apply-inlines" />
    </fo:basic-link>
  </xsl:template>
  <xsl:template match="i">
    <fo:inline font-style="italic">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="b">
    <fo:inline font-weight="bold">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="u">
    <fo:inline text-decoration="underline">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="ul | ol">
    <fo:list-block xsl:use-attribute-sets="list" provisional-distance-between-starts="{$list-start-distance}" provisional-label-separation="{$list-label-separation}">
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="li" />
    </fo:list-block>
  </xsl:template>
  <xsl:template match="li">
    <fo:list-item xsl:use-attribute-sets="list-item">
      <xsl:call-template name="process-common-attributes" />
      <fo:list-item-label end-indent="label-end()">
        <xsl:if test="../self::ul">
          <xsl:attribute name="font-family">
            <xsl:value-of select="$ul-label-font-family" />
          </xsl:attribute>
          <xsl:attribute name="font-size">
            <xsl:value-of select="$ul-label-font-size" />
          </xsl:attribute>
          <xsl:attribute name="font-weight">
            <xsl:value-of select="$ul-label-font-weight" />
          </xsl:attribute>
          <xsl:attribute name="font-style">
            <xsl:value-of select="$ul-label-font-style" />
          </xsl:attribute>
        </xsl:if>
        <xsl:if test="../self::ol">
          <xsl:attribute name="font-family">
            <xsl:value-of select="$ol-label-font-family" />
          </xsl:attribute>
          <xsl:attribute name="font-size">
            <xsl:value-of select="$ol-label-font-size" />
          </xsl:attribute>
          <xsl:attribute name="font-weight">
            <xsl:value-of select="$ol-label-font-weight" />
          </xsl:attribute>
          <xsl:attribute name="font-style">
            <xsl:value-of select="$ol-label-font-style" />
          </xsl:attribute>
        </xsl:if>
        <fo:block text-align="end">
          <xsl:attribute name="axf:number-transform">
            <xsl:choose>
              <xsl:when test="../@type">
                <xsl:value-of select="../@type" />
              </xsl:when>
              <xsl:when test="../self::ul">
                <xsl:variable name="nest" select="count(ancestor::ol | ancestor::ul)" />
                <xsl:choose>
                  <xsl:when test="$nest=1">
                    <xsl:text>disc</xsl:text>
                  </xsl:when>
                  <xsl:when test="$nest=2">
                    <xsl:text>circle</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>square</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:when test="../self::ol">
                <xsl:text>1.</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:attribute>
          <xsl:number />
        </fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block>
          <xsl:call-template name="apply-blocks-and-inlines" />
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
  <xsl:template match="img">
    <fo:external-graphic src="{@src}" axf:alttext="{@alt}">
      <xsl:call-template name="process-common-attributes" />
      <xsl:if test="../self::figure">
        <xsl:attribute name="alignment-baseline">bottom</xsl:attribute>
      </xsl:if>
    </fo:external-graphic>
  </xsl:template>
  <xsl:template match="figure">
    <fo:table-and-caption>
      <xsl:if test="@align">
        <xsl:attribute name="text-align">
          <xsl:value-of select="@align" />
        </xsl:attribute>
      </xsl:if>
      <fo:table>
        <fo:table-body>
          <fo:table-row>
            <fo:table-cell text-align="center">
              <fo:block xsl:use-attribute-sets="figure">
                <xsl:call-template name="process-common-attributes" />
                <xsl:apply-templates select="img" />
              </fo:block>
              <xsl:if test="*[1][self::title]">
                <fo:block keep-with-previous="always" font-family="{$figure-title-font-family}" font-size="{$figure-title-font-size}">
                  <xsl:apply-templates select="title[1]" />
                </fo:block>
              </xsl:if>
            </fo:table-cell>
          </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:table-and-caption>
  </xsl:template>
  <xsl:template match="table">
    <fo:table-and-caption>
      <xsl:if test="@align">
        <xsl:attribute name="text-align">
          <xsl:value-of select="@align" />
        </xsl:attribute>
      </xsl:if>
      <fo:table>
        <fo:table-body>
          <fo:table-row>
            <fo:table-cell text-align="center">
              <fo:table xsl:use-attribute-sets="table">
                <xsl:call-template name="process-common-attributes" />
                <xsl:apply-templates select="thead[1]" />
                <xsl:apply-templates select="tfoot[1]" />
                <xsl:apply-templates select="tbody" />
              </fo:table>
              <xsl:if test="*[1][self::title]">
                <fo:block keep-with-previous="always" font-family="{$table-title-font-family}" font-size="{$table-title-font-size}">
                  <xsl:apply-templates select="title[1]" />
                </fo:block>
              </xsl:if>
            </fo:table-cell>
          </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:table-and-caption>
  </xsl:template>
  <xsl:template match="thead">
    <fo:table-header>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-header>
  </xsl:template>
  <xsl:template match="tfoot">
    <fo:table-footer>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-footer>
  </xsl:template>
  <xsl:template match="tbody">
    <fo:table-body>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-body>
  </xsl:template>
  <xsl:template match="tr">
    <fo:table-row>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="th | td" />
    </fo:table-row>
  </xsl:template>
  <xsl:template match="th">
    <fo:table-cell xsl:use-attribute-sets="th">
      <xsl:call-template name="process-cell-attributes" />
      <fo:block>
        <xsl:call-template name="apply-blocks-and-inlines" />
      </fo:block>
    </fo:table-cell>
  </xsl:template>
  <xsl:template match="td">
    <fo:table-cell xsl:use-attribute-sets="td">
      <xsl:call-template name="process-cell-attributes" />
      <fo:block>
        <xsl:call-template name="apply-blocks-and-inlines" />
      </fo:block>
    </fo:table-cell>
  </xsl:template>
  <xsl:template name="process-cell-attributes">
    <xsl:call-template name="process-common-attributes" />
    <xsl:if test="@rowspan">
      <xsl:attribute name="number-rows-spanned">
        <xsl:value-of select="@rowspan" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@colspan">
      <xsl:attribute name="number-columns-spanned">
        <xsl:value-of select="@colspan" />
      </xsl:attribute>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>