﻿<?xml version="1.0" encoding="utf-8"?>
<!-- Antenna House : AH Formatter Sample 
【発行】アンテナハウス株式会社
【作成日】2016/11/15（ver.1）
【著作権の扱い】CC-BY(本サンプル集を複製または改変し、頒布や実演を行う際は著作権者の表示をしてください)
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions">
  <xsl:output method="xml" encoding="UTF-8" />
  <xsl:param name="page-width" select="'210mm'" />
  <xsl:param name="page-height" select="'297mm'" />
  <xsl:param name="margin-top" select="'2cm'" />
  <xsl:param name="margin-bottom" select="'2cm'" />
  <xsl:param name="margin-outside" select="'2cm'" />
  <xsl:param name="margin-inside" select="'2.5cm'" />
  <xsl:param name="font-family" select="'serif'" />
  <xsl:param name="font-size" select="'10pt'" />
  <xsl:param name="line-height" select="1.7" />
  <xsl:param name="column-count" select="1" />
  <xsl:param name="column-gap" select="'20pt'" />
  <xsl:param name="new-chapter" select="'han-tobira'" />
  <xsl:param name="chapter-font-family" select="'sans-serif'" />
  <xsl:param name="chapter-font-size" select="'2rem'" />
  <xsl:param name="chapter-font-weight" select="'bold'" />
  <xsl:param name="chapter-start-indent" select="'0rem'" />
  <xsl:param name="chapter-span" select="'all'" />
  <xsl:param name="section-font-family" select="'sans-serif'" />
  <xsl:param name="section-font-size" select="'1.5rem'" />
  <xsl:param name="section-font-weight" select="'bold'" />
  <xsl:param name="section-start-indent" select="'0rem'" />
  <xsl:param name="section-span" select="'none'" />
  <xsl:param name="subsection-font-family" select="'sans-serif'" />
  <xsl:param name="subsection-font-size" select="'1.17rem'" />
  <xsl:param name="subsection-font-weight" select="'bold'" />
  <xsl:param name="subsection-start-indent" select="'0rem'" />
  <xsl:param name="subsection-span" select="'none'" />
  <xsl:param name="list-start-distance" select="'2em'" />
  <xsl:param name="list-label-separation" select="'0.5em'" />
  <xsl:param name="ul-label-font-family">sans-serif</xsl:param>
  <xsl:param name="ul-label-font-size">1rem</xsl:param>
  <xsl:param name="ul-label-font-weight">normal</xsl:param>
  <xsl:param name="ul-label-font-style">normal</xsl:param>
  <xsl:param name="ol-label-font-family">sans-serif</xsl:param>
  <xsl:param name="ol-label-font-size">1rem</xsl:param>
  <xsl:param name="ol-label-font-weight">normal</xsl:param>
  <xsl:param name="ol-label-font-style">normal</xsl:param>
  <xsl:param name="figure-title-font-family" select="'sans-serif'" />
  <xsl:param name="figure-title-font-size" select="'0.8em'" />
  <xsl:param name="table-border" select="'solid 2pt'" />
  <xsl:param name="cell-border" select="'solid 1pt'" />
  <xsl:param name="cell-padding" select="'0.2em'" />
  <xsl:param name="table-title-font-family" select="'sans-serif'" />
  <xsl:param name="table-title-font-size" select="'0.8em'" />
  <xsl:param name="header-font-family" select="'sans-serif'" />
  <xsl:param name="header-font-size" select="'0.8rem'" />
  <xsl:param name="header-margin" select="'2em'" />
  <xsl:param name="header-indent" select="$margin-outside" />
  <xsl:param name="footer-font-family" select="'sans-serif'" />
  <xsl:param name="footer-font-size" select="'0.8rem'" />
  <xsl:param name="footer-margin" select="'2em'" />
  <xsl:param name="footer-indent" select="$margin-outside" />
  <xsl:param name="toc-column-count" select="$column-count" />
  <xsl:param name="toc-column-gap" select="$column-gap" />
  <xsl:param name="toc-item-font-family" select="'sans-serif'" />
  <xsl:param name="toc-chapter-font-size" select="'1rem'" />
  <xsl:param name="toc-chapter-font-weight" select="'normal'" />
  <xsl:param name="toc-chapter-start-indent" select="'0em'" />
  <xsl:param name="toc-section-font-size" select="'1rem'" />
  <xsl:param name="toc-section-font-weight" select="'normal'" />
  <xsl:param name="toc-section-start-indent" select="'1em'" />
  <xsl:param name="toc-subsection-font-size" select="'1rem'" />
  <xsl:param name="toc-subsection-font-weight" select="'normal'" />
  <xsl:param name="toc-subsection-start-indent" select="'2em'" />
  <xsl:param name="toc-pagenum-font-family" select="'serif'" />
  <xsl:param name="toc-pagenum-font-size" select="'1rem'" />
  <xsl:param name="toc-pagenum-font-weight" select="'normal'" />
  <xsl:param name="toc-level" select="'subsection'" />
  <xsl:param name="index-column-count" select="2" />
  <xsl:param name="index-column-gap" select="$column-gap" />
  <xsl:param name="index-item-font-family" select="'sans-serif'" />
  <xsl:param name="index-item-font-size" select="'1rem'" />
  <xsl:param name="index-item-font-weight" select="'normal'" />
  <xsl:param name="index-item-start-indent" select="'0em'" />
  <xsl:param name="index-pagenum-font-family" select="'serif'" />
  <xsl:param name="index-pagenum-font-size" select="'1rem'" />
  <xsl:param name="index-pagenum-font-weight" select="'normal'" />
  <xsl:param name="chapter-gyodori" select="4" />
  <xsl:param name="chapter-line-height" select="$line-height" />
  <xsl:param name="section-gyodori" select="3" />
  <xsl:param name="section-line-height" select="$line-height" />
  <xsl:param name="subsection-gyodori" select="2" />
  <xsl:param name="subsection-line-height" select="$line-height" />
  <xsl:param name="auto-letter-spacing">1em 0.5em 0.25em</xsl:param>
  <xsl:attribute-set name="p">
    <xsl:attribute name="text-align">justify</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="pre">
    <xsl:attribute name="font-family">monospace</xsl:attribute>
    <xsl:attribute name="white-space">pre</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="table">
    <xsl:attribute name="border-collapse">collapse</xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$table-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="th">
    <xsl:attribute name="font-weight">bold</xsl:attribute>
    <xsl:attribute name="text-align">center</xsl:attribute>
    <xsl:attribute name="padding">
      <xsl:value-of select="$cell-padding" />
    </xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$cell-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="td">
    <xsl:attribute name="font-weight">normal</xsl:attribute>
    <xsl:attribute name="text-align">start</xsl:attribute>
    <xsl:attribute name="padding">
      <xsl:value-of select="$cell-padding" />
    </xsl:attribute>
    <xsl:attribute name="border">
      <xsl:value-of select="$cell-border" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="figure">
    <xsl:attribute name="line-height">1</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="chapter"></xsl:attribute-set>
  <xsl:attribute-set name="section"></xsl:attribute-set>
  <xsl:attribute-set name="subsection"></xsl:attribute-set>
  <xsl:attribute-set name="a"></xsl:attribute-set>
  <xsl:attribute-set name="list"></xsl:attribute-set>
  <xsl:attribute-set name="list-item"></xsl:attribute-set>
  <xsl:attribute-set name="tobira">
    <xsl:attribute name="font-family">sans-serif</xsl:attribute>
    <xsl:attribute name="font-size">40pt</xsl:attribute>
    <xsl:attribute name="text-align">center</xsl:attribute>
    <xsl:attribute name="line-height">2.5</xsl:attribute>
    <xsl:attribute name="space-before">2em</xsl:attribute>
    <xsl:attribute name="space-before.conditionality">retain</xsl:attribute>
    <xsl:attribute name="border-before-style">solid</xsl:attribute>
    <xsl:attribute name="border-after-style">solid</xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="toc"></xsl:attribute-set>
  <xsl:attribute-set name="toc-item">
    <xsl:attribute name="space-end">0.5em</xsl:attribute>
    <xsl:attribute name="font-family">
      <xsl:value-of select="$toc-item-font-family" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="toc-pagenum">
    <xsl:attribute name="space-start">0.5em</xsl:attribute>
    <xsl:attribute name="font-family">
      <xsl:value-of select="$toc-pagenum-font-family" />
    </xsl:attribute>
    <xsl:attribute name="font-size">
      <xsl:value-of select="$toc-pagenum-font-size" />
    </xsl:attribute>
    <xsl:attribute name="font-weight">
      <xsl:value-of select="$toc-pagenum-font-weight" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="index-pagenum">
    <xsl:attribute name="font-family">
      <xsl:value-of select="$index-pagenum-font-family" />
    </xsl:attribute>
    <xsl:attribute name="font-size">
      <xsl:value-of select="$index-pagenum-font-size" />
    </xsl:attribute>
    <xsl:attribute name="font-weight">
      <xsl:value-of select="$index-pagenum-font-weight" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:attribute-set name="index"></xsl:attribute-set>
  <xsl:attribute-set name="index-item">
    <xsl:attribute name="space-end">0.5em</xsl:attribute>
    <xsl:attribute name="font-family">
      <xsl:value-of select="$index-item-font-family" />
    </xsl:attribute>
    <xsl:attribute name="font-size">
      <xsl:value-of select="$index-item-font-size" />
    </xsl:attribute>
    <xsl:attribute name="font-weight">
      <xsl:value-of select="$index-item-font-weight" />
    </xsl:attribute>
  </xsl:attribute-set>
  <xsl:template name="process-common-attributes">
    <xsl:copy-of select="@id" />
    <xsl:copy-of select="@xml:lang" />
  </xsl:template>
  <xsl:template match="doc">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions" font-family="{$font-family}" font-size="{$font-size}" line-height="{$line-height}">
      <xsl:call-template name="process-common-attributes" />
      <fo:layout-master-set>
        <fo:simple-page-master master-name="left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body column-count="{$column-count}" column-gap="{$column-gap}" margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" />
          <fo:region-before region-name="left-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" />
          <fo:region-before region-name="right-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="right-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="main">
          <fo:repeatable-page-master-alternatives>
            <fo:conditional-page-master-reference master-reference="blank-page" blank-or-not-blank="blank" />
            <fo:conditional-page-master-reference master-reference="first-right" odd-or-even="odd" page-position="first" />
            <fo:conditional-page-master-reference master-reference="first-left" odd-or-even="even" page-position="first" />
            <fo:conditional-page-master-reference master-reference="right" odd-or-even="odd" />
            <fo:conditional-page-master-reference master-reference="left" odd-or-even="even" />
          </fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
        <fo:simple-page-master master-name="first-left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" column-count="{$column-count}" column-gap="{$column-gap}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="first-right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" column-count="{$column-count}" column-gap="{$column-gap}" />
          <fo:region-after region-name="right-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="blank-page" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="tobira" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="toc-left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" column-count="{$toc-column-count}" column-gap="{$toc-column-gap}" />
          <fo:region-before region-name="left-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="toc-right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" column-count="{$toc-column-count}" column-gap="{$toc-column-gap}" />
          <fo:region-before region-name="left-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="toc-first-left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" column-count="{$toc-column-count}" column-gap="{$toc-column-gap}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="toc-first-right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" column-count="{$toc-column-count}" column-gap="{$toc-column-gap}" />
          <fo:region-after region-name="right-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="toc">
          <fo:repeatable-page-master-alternatives>
            <fo:conditional-page-master-reference master-reference="blank-page" blank-or-not-blank="blank" />
            <fo:conditional-page-master-reference master-reference="toc-first-right" odd-or-even="odd" page-position="first" />
            <fo:conditional-page-master-reference master-reference="toc-first-left" odd-or-even="even" page-position="first" />
            <fo:conditional-page-master-reference master-reference="toc-right" odd-or-even="odd" />
            <fo:conditional-page-master-reference master-reference="toc-left" odd-or-even="even" />
          </fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
        <fo:simple-page-master master-name="index-left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" column-count="{$index-column-count}" column-gap="{$index-column-gap}" />
          <fo:region-before region-name="left-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="index-right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" column-count="{$index-column-count}" column-gap="{$index-column-gap}" />
          <fo:region-before region-name="left-region-header" extent="{$margin-top}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="index-first-left" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-outside}" margin-right="{$margin-inside}" column-count="{$index-column-count}" column-gap="{$index-column-gap}" />
          <fo:region-after region-name="left-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:simple-page-master master-name="index-first-right" page-width="{$page-width}" page-height="{$page-height}">
          <fo:region-body margin-top="{$margin-top}" margin-bottom="{$margin-bottom}" margin-left="{$margin-inside}" margin-right="{$margin-outside}" column-count="{$index-column-count}" column-gap="{$index-column-gap}" />
          <fo:region-after region-name="right-region-footer" extent="{$margin-bottom}" />
        </fo:simple-page-master>
        <fo:page-sequence-master master-name="index">
          <fo:repeatable-page-master-alternatives>
            <fo:conditional-page-master-reference master-reference="blank-page" blank-or-not-blank="blank" />
            <fo:conditional-page-master-reference master-reference="index-first-right" odd-or-even="odd" page-position="first" />
            <fo:conditional-page-master-reference master-reference="index-first-left" odd-or-even="even" page-position="first" />
            <fo:conditional-page-master-reference master-reference="index-right" odd-or-even="odd" />
            <fo:conditional-page-master-reference master-reference="index-left" odd-or-even="even" />
          </fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
      </fo:layout-master-set>
      <xsl:apply-templates select="front" />
      <xsl:apply-templates select="body" />
      <xsl:apply-templates select="back" />
    </fo:root>
  </xsl:template>
  <xsl:template match="body">
    <xsl:choose>
      <xsl:when test="chapter">
        <xsl:apply-templates select="chapter" />
      </xsl:when>
      <xsl:otherwise>
        <fo:page-sequence master-reference="main">
          <fo:flow flow-name="xsl-region-body">
            <xsl:call-template name="process-common-attributes" />
            <xsl:apply-templates select="p | pre | ul | ol | figure | table" />
          </fo:flow>
        </fo:page-sequence>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="chapter">
    <xsl:variable name="make-tobira" select="$new-chapter='han-tobira'         or $new-chapter='naka-tobira'" />
    <xsl:if test="$make-tobira">
      <xsl:call-template name="make-tobira">
        <xsl:with-param name="title" select="title[1]" />
      </xsl:call-template>
    </xsl:if>
    <fo:page-sequence master-reference="main">
      <xsl:if test="$new-chapter='new-recto' or $new-chapter='naka-tobira'       or ($new-chapter='han-tobira' and not(title))">
        <xsl:attribute name="initial-page-number">auto-odd</xsl:attribute>
      </xsl:if>
      <xsl:call-template name="make-headerfooter" />
      <fo:static-content flow-name="right-region-footer">
        <fo:block font-family="{$footer-font-family}" font-size="{$footer-font-size}" end-indent="{$footer-indent}" space-before="{$footer-margin}" space-before.conditionality="retain" line-height="1" text-align="right">
          <fo:page-number />
        </fo:block>
      </fo:static-content>
      <fo:static-content flow-name="left-region-footer">
        <fo:block font-family="{$footer-font-family}" font-size="{$footer-font-size}" start-indent="{$footer-indent}" space-before="{$footer-margin}" space-before.conditionality="retain" line-height="1">
          <fo:page-number />
        </fo:block>
      </fo:static-content>
      <fo:static-content flow-name="left-region-header">
        <fo:block font-family="{$header-font-family}" font-size="{$header-font-size}" start-indent="{$header-indent}" space-before="{$margin-top} -{$header-font-size} -{$header-margin}" space-before.conditionality="retain" line-height="1">
          <fo:retrieve-marker retrieve-class-name="left-header" retrieve-boundary="document" />
        </fo:block>
      </fo:static-content>
      <fo:static-content flow-name="right-region-header">
        <fo:block font-family="{$header-font-family}" font-size="{$header-font-size}" end-indent="{$header-indent}" space-before="{$margin-top} -{$header-font-size} -{$header-margin}" space-before.conditionality="retain" line-height="1" text-align="right">
          <fo:retrieve-marker retrieve-class-name="right-header" />
        </fo:block>
      </fo:static-content>
      <fo:flow flow-name="xsl-region-body">
        <fo:block id="{generate-id()}">
          <fo:block xsl:use-attribute-sets="chapter">
            <xsl:if test="not($make-tobira)">
              <xsl:call-template name="process-common-attributes" />
            </xsl:if>
            <xsl:if test="not($new-chapter='han-tobira' or       $new-chapter='naka-tobira') and *[1][self::title]">
              <xsl:call-template name="make-title">
                <xsl:with-param name="title" select="title[1]" />
              </xsl:call-template>
            </xsl:if>
            <xsl:call-template name="apply-blocks">
              <xsl:with-param name="extra-blocks" select="section" />
            </xsl:call-template>
          </fo:block>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>
  <xsl:template name="make-title">
    <xsl:param name="title" select="/.." />
    <xsl:param name="type" />
    <xsl:param name="style" select="'complete'" />
    <xsl:param name="alt-title" />
    <xsl:choose>
      <xsl:when test="self::chapter or $type='chapter'">
        <fo:block>
          <xsl:if test="$type!='tobira'">
            <xsl:attribute name="keep-with-next">always</xsl:attribute>
            <xsl:attribute name="font-family">
              <xsl:value-of select="$chapter-font-family" />
            </xsl:attribute>
            <xsl:attribute name="font-size">
              <xsl:value-of select="$chapter-font-size" />
            </xsl:attribute>
            <xsl:attribute name="font-weight">
              <xsl:value-of select="$chapter-font-weight" />
            </xsl:attribute>
            <xsl:attribute name="start-indent">
              <xsl:value-of select="$chapter-start-indent" />
            </xsl:attribute>
            <xsl:attribute name="line-height">
              <xsl:value-of select="$chapter-line-height" />
            </xsl:attribute>
            <xsl:attribute name="span">
              <xsl:value-of select="$chapter-span" />
            </xsl:attribute>
            <xsl:attribute name="space-before">
              <xsl:value-of select="concat('(',$chapter-gyodori,'rlh - 1lh) div 2')" />
            </xsl:attribute>
            <xsl:attribute name="space-after">
              <xsl:value-of select="concat('(',$chapter-gyodori,'rlh - 1lh) div 2')" />
            </xsl:attribute>
            <xsl:attribute name="space-before.conditionality">retain</xsl:attribute>
            <xsl:attribute name="space-after.conditionality">retain</xsl:attribute>
          </xsl:if>
          <fo:marker marker-class-name="left-header">
            <xsl:call-template name="make-title-number">
              <xsl:with-param name="type">chapter</xsl:with-param>
              <xsl:with-param name="title" select="$title" />
              <xsl:with-param name="style" select="$style" />
              <xsl:with-param name="alt-title" select="$alt-title" />
              <xsl:with-param name="mode">toc</xsl:with-param>
            </xsl:call-template>
          </fo:marker>
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type">chapter</xsl:with-param>
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="alt-title" select="$alt-title" />
          </xsl:call-template>
        </fo:block>
      </xsl:when>
      <xsl:when test="self::section">
        <fo:block keep-with-next="always" font-family="{$section-font-family}" font-size="{$section-font-size}" font-weight="{$section-font-weight}" start-indent="{$section-start-indent}" line-height="{$section-line-height}" span="{$section-span}">
          <xsl:attribute name="space-before">
            <xsl:value-of select="concat('(',$section-gyodori,'rlh - 1lh) div 2')" />
          </xsl:attribute>
          <xsl:attribute name="space-after">
            <xsl:value-of select="concat('(',$section-gyodori,'rlh - 1lh) div 2')" />
          </xsl:attribute>
          <fo:marker marker-class-name="right-header">
            <xsl:call-template name="make-title-number">
              <xsl:with-param name="type">section</xsl:with-param>
              <xsl:with-param name="title" select="$title" />
              <xsl:with-param name="style" select="$style" />
              <xsl:with-param name="alt-title" select="$alt-title" />
              <xsl:with-param name="mode">toc</xsl:with-param>
            </xsl:call-template>
          </fo:marker>
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type">section</xsl:with-param>
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="alt-title" select="$alt-title" />
          </xsl:call-template>
        </fo:block>
      </xsl:when>
      <xsl:when test="self::subsection or $type='subsection'">
        <fo:block keep-with-next="always" font-family="{$subsection-font-family}" font-size="{$subsection-font-size}" font-weight="{$subsection-font-weight}" start-indent="{$subsection-start-indent}" line-height="{$subsection-line-height}" span="{$subsection-span}">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type">subsection</xsl:with-param>
            <xsl:with-param name="title" select="$title" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="alt-title" select="$alt-title" />
          </xsl:call-template>
        </fo:block>
      </xsl:when>
      <xsl:when test="self::figure">
        <fo:block keep-with-previous="always" font-family="{$figure-title-font-family}" font-size="{$figure-title-font-size}">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type">figure</xsl:with-param>
            <xsl:with-param name="title" select="$title" />
          </xsl:call-template>
        </fo:block>
      </xsl:when>
      <xsl:when test="self::table">
        <fo:block keep-with-previous="always" font-family="{$table-title-font-family}" font-size="{$table-title-font-size}">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type">table</xsl:with-param>
            <xsl:with-param name="title" select="$title" />
          </xsl:call-template>
        </fo:block>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="title">
    <fo:inline>
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template name="apply-inlines">
    <xsl:apply-templates select="a | i | b | u | img | ruby | citation | index | text()" />
  </xsl:template>
  <xsl:template match="p">
    <fo:block xsl:use-attribute-sets="p">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-blocks-and-inlines" />
    </fo:block>
  </xsl:template>
  <xsl:template match="pre">
    <fo:block xsl:use-attribute-sets="pre">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-blocks-and-inlines" />
    </fo:block>
  </xsl:template>
  <xsl:template name="apply-blocks-and-inlines">
    <xsl:apply-templates select="p | pre | ul | ol | figure | table | a | i | b | u | img|ruby | citation | index | text()" />
  </xsl:template>
  <xsl:template match="a">
    <fo:basic-link xsl:use-attribute-sets="a">
      <xsl:call-template name="process-common-attributes" />
      <xsl:choose>
        <xsl:when test="starts-with(@href,'#')">
          <xsl:attribute name="internal-destination">
            <xsl:value-of select="substring-after(@href,'#')" />
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="external-destination">
            <xsl:value-of select="@href" />
          </xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="apply-inlines" />
    </fo:basic-link>
  </xsl:template>
  <xsl:template match="i">
    <fo:inline font-style="italic">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="b">
    <fo:inline font-weight="bold">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="u">
    <fo:inline text-decoration="underline">
      <xsl:call-template name="process-common-attributes" />
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template match="ul | ol">
    <fo:list-block xsl:use-attribute-sets="list" provisional-distance-between-starts="{$list-start-distance}" provisional-label-separation="{$list-label-separation}">
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="li" />
    </fo:list-block>
  </xsl:template>
  <xsl:template match="li">
    <fo:list-item xsl:use-attribute-sets="list-item">
      <xsl:call-template name="process-common-attributes" />
      <fo:list-item-label end-indent="label-end()">
        <xsl:if test="../self::ul">
          <xsl:attribute name="font-family">
            <xsl:value-of select="$ul-label-font-family" />
          </xsl:attribute>
          <xsl:attribute name="font-size">
            <xsl:value-of select="$ul-label-font-size" />
          </xsl:attribute>
          <xsl:attribute name="font-weight">
            <xsl:value-of select="$ul-label-font-weight" />
          </xsl:attribute>
          <xsl:attribute name="font-style">
            <xsl:value-of select="$ul-label-font-style" />
          </xsl:attribute>
        </xsl:if>
        <xsl:if test="../self::ol">
          <xsl:attribute name="font-family">
            <xsl:value-of select="$ol-label-font-family" />
          </xsl:attribute>
          <xsl:attribute name="font-size">
            <xsl:value-of select="$ol-label-font-size" />
          </xsl:attribute>
          <xsl:attribute name="font-weight">
            <xsl:value-of select="$ol-label-font-weight" />
          </xsl:attribute>
          <xsl:attribute name="font-style">
            <xsl:value-of select="$ol-label-font-style" />
          </xsl:attribute>
        </xsl:if>
        <fo:block text-align="end">
          <xsl:call-template name="make-list-label" />
        </fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block>
          <xsl:call-template name="apply-blocks-and-inlines" />
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
  <xsl:template match="img">
    <fo:external-graphic src="{@src}" axf:alttext="{@alt}">
      <xsl:call-template name="process-common-attributes" />
      <xsl:if test="../self::figure">
        <xsl:attribute name="alignment-baseline">bottom</xsl:attribute>
      </xsl:if>
    </fo:external-graphic>
  </xsl:template>
  <xsl:template match="figure">
    <xsl:choose>
      <xsl:when test="@float='before' or @float='after'">
        <fo:float axf:float-x="{@align}" axf:float-y="{@float}" axf:float-wrap="skip" axf:float-reference="page">
          <xsl:call-template name="make-figure" />
        </fo:float>
      </xsl:when>
      <xsl:when test="@float='auto-next' or @float='auto-move'">
        <fo:float axf:float-x="{@align}" axf:float-y="none" axf:float-move="{@float}" axf:float-wrap="skip" axf:float-reference="page">
          <xsl:if test="not(@align)">
            <xsl:attribute name="axf:float-x">left</xsl:attribute>
          </xsl:if>
          <xsl:call-template name="make-figure" />
        </fo:float>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="make-figure">
          <xsl:with-param name="align" select="@align" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="make-figure">
    <xsl:param name="align" />
    <fo:table-and-caption>
      <xsl:if test="$align">
        <xsl:attribute name="text-align">
          <xsl:value-of select="$align" />
        </xsl:attribute>
      </xsl:if>
      <fo:table>
        <fo:table-body>
          <fo:table-row>
            <fo:table-cell text-align="center">
              <fo:block xsl:use-attribute-sets="figure">
                <xsl:call-template name="process-common-attributes" />
                <xsl:apply-templates select="img" />
              </fo:block>
              <xsl:if test="*[1][self::title]">
                <xsl:call-template name="make-title">
                  <xsl:with-param name="title" select="title[1]" />
                </xsl:call-template>
              </xsl:if>
            </fo:table-cell>
          </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:table-and-caption>
  </xsl:template>
  <xsl:template match="table">
    <fo:table-and-caption>
      <xsl:if test="@align">
        <xsl:attribute name="text-align">
          <xsl:value-of select="@align" />
        </xsl:attribute>
      </xsl:if>
      <fo:table>
        <fo:table-body>
          <fo:table-row>
            <fo:table-cell text-align="center">
              <fo:table xsl:use-attribute-sets="table">
                <xsl:call-template name="process-common-attributes" />
                <xsl:apply-templates select="thead[1]" />
                <xsl:apply-templates select="tfoot[1]" />
                <xsl:apply-templates select="tbody" />
              </fo:table>
              <xsl:if test="*[1][self::title]">
                <xsl:call-template name="make-title">
                  <xsl:with-param name="title" select="title[1]" />
                </xsl:call-template>
              </xsl:if>
            </fo:table-cell>
          </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:table-and-caption>
  </xsl:template>
  <xsl:template match="thead">
    <fo:table-header>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-header>
  </xsl:template>
  <xsl:template match="tfoot">
    <fo:table-footer>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-footer>
  </xsl:template>
  <xsl:template match="tbody">
    <fo:table-body>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="tr" />
    </fo:table-body>
  </xsl:template>
  <xsl:template match="tr">
    <fo:table-row>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="th | td" />
    </fo:table-row>
  </xsl:template>
  <xsl:template match="th">
    <fo:table-cell xsl:use-attribute-sets="th">
      <xsl:call-template name="process-cell-attributes" />
      <fo:block>
        <xsl:call-template name="apply-blocks-and-inlines" />
      </fo:block>
    </fo:table-cell>
  </xsl:template>
  <xsl:template match="td">
    <fo:table-cell xsl:use-attribute-sets="td">
      <xsl:call-template name="process-cell-attributes" />
      <fo:block>
        <xsl:call-template name="apply-blocks-and-inlines" />
      </fo:block>
    </fo:table-cell>
  </xsl:template>
  <xsl:template name="process-cell-attributes">
    <xsl:call-template name="process-common-attributes" />
    <xsl:if test="@rowspan">
      <xsl:attribute name="number-rows-spanned">
        <xsl:value-of select="@rowspan" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@colspan">
      <xsl:attribute name="number-columns-spanned">
        <xsl:value-of select="@colspan" />
      </xsl:attribute>
    </xsl:if>
  </xsl:template>
  <xsl:template name="make-tobira">
    <xsl:param name="title" select="/.." />
    <xsl:if test="title">
      <fo:page-sequence master-reference="tobira" initial-page-number="auto-odd">
        <fo:flow flow-name="xsl-region-body">
          <xsl:call-template name="process-common-attributes" />
          <fo:block-container xsl:use-attribute-sets="tobira">
            <xsl:call-template name="make-title">
              <xsl:with-param name="type" select="'tobira'" />
              <xsl:with-param name="title" select="title[1]" />
            </xsl:call-template>
          </fo:block-container>
        </fo:flow>
      </fo:page-sequence>
    </xsl:if>
  </xsl:template>
  <xsl:template match="section">
    <fo:block id="{generate-id()}">
      <fo:block xsl:use-attribute-sets="section">
        <xsl:call-template name="process-common-attributes" />
        <xsl:if test="*[1][self::title]">
          <xsl:call-template name="make-title">
            <xsl:with-param name="title" select="title[1]" />
          </xsl:call-template>
        </xsl:if>
        <xsl:apply-templates select="subsection | p | pre | ul | ol | figure | table" />
      </fo:block>
    </fo:block>
  </xsl:template>
  <xsl:template match="subsection">
    <fo:block id="{generate-id()}">
      <fo:block xsl:use-attribute-sets="subsection">
        <xsl:call-template name="process-common-attributes" />
        <xsl:if test="*[1][self::title]">
          <xsl:call-template name="make-title">
            <xsl:with-param name="title" select="title[1]" />
          </xsl:call-template>
        </xsl:if>
        <xsl:call-template name="apply-blocks" />
      </fo:block>
    </fo:block>
  </xsl:template>
  <xsl:template name="apply-blocks">
    <xsl:param name="extra-blocks" select="/.." />
    <xsl:apply-templates select="$extra-blocks | p | pre | ul | ol | figure | table" />
  </xsl:template>
  <xsl:template name="make-headerfooter">
    <fo:static-content flow-name="left-region-header">
      <fo:block font-family="{$header-font-family}" font-size="{$header-font-size}" start-indent="{$header-indent}" space-before="{$margin-top} -{$header-font-size} -{$header-margin}" space-before.conditionality="retain" line-height="1">
        <fo:retrieve-marker retrieve-class-name="left-header" retrieve-boundary="document" />
      </fo:block>
    </fo:static-content>
    <fo:static-content flow-name="right-region-header">
      <fo:block font-family="{$header-font-family}" font-size="{$header-font-size}" end-indent="{$header-indent}" space-before="{$margin-top} -{$header-font-size} -{$header-margin}" space-before.conditionality="retain" line-height="1" text-align="right">
        <fo:retrieve-marker retrieve-class-name="right-header" />
      </fo:block>
    </fo:static-content>
    <fo:static-content flow-name="left-region-footer">
      <fo:block font-family="{$footer-font-family}" font-size="{$footer-font-size}" start-indent="{$footer-indent}" space-before="{$footer-margin}" space-before.conditionality="retain" line-height="1">
        <fo:page-number />
      </fo:block>
    </fo:static-content>
    <fo:static-content flow-name="right-region-footer">
      <fo:block font-family="{$footer-font-family}" font-size="{$footer-font-size}" end-indent="{$footer-indent}" space-before="{$footer-margin}" space-before.conditionality="retain" line-height="1" text-align="right">
        <fo:page-number />
      </fo:block>
    </fo:static-content>
  </xsl:template>
  <xsl:template name="make-title-number">
    <xsl:param name="type" select="'page'" />
    <xsl:param name="style" select="'complete'" />
    <xsl:param name="title" select="/.." />
    <xsl:param name="alt-title" />
    <xsl:param name="mode" />
    <xsl:choose>
      <xsl:when test="$type='chapter'">
        <xsl:if test="$style!='title'">
          <fo:inline>
            <xsl:if test="$style='number'">
              <xsl:number count="chapter" />
            </xsl:if>
            <xsl:if test="$style='formatted' or $style='complete'">
              <xsl:text>第</xsl:text>
              <xsl:number count="chapter" />
              <xsl:text>章</xsl:text>
            </xsl:if>
          </fo:inline>
        </xsl:if>
        <xsl:if test="$style='title' or $style='complete'">
          <xsl:text></xsl:text>
          <fo:inline>
            <xsl:if test="not($mode)">
              <xsl:attribute name="axf:auto-letter-spacing">
                <xsl:value-of select="$auto-letter-spacing" />
              </xsl:attribute>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="not($title)">
                <xsl:copy-of select="$alt-title" />
              </xsl:when>
              <xsl:when test="$mode='toc'">
                <xsl:apply-templates select="$title" mode="toc" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$title" />
              </xsl:otherwise>
            </xsl:choose>
          </fo:inline>
        </xsl:if>
      </xsl:when>
      <xsl:when test="$type='section'">
        <xsl:if test="$style!='title'">
          <fo:inline>
            <xsl:if test="$style='number'">
              <xsl:number count="section" />
            </xsl:if>
            <xsl:if test="$style='formatted' or $style='complete'">
              <xsl:number count="chapter | section" level="multiple" />
            </xsl:if>
          </fo:inline>
        </xsl:if>
        <xsl:if test="$style='title' or $style='complete'">
          <xsl:text></xsl:text>
          <fo:inline>
            <xsl:if test="not($mode)">
              <xsl:attribute name="axf:auto-letter-spacing">
                <xsl:value-of select="$auto-letter-spacing" />
              </xsl:attribute>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="not($title)">
                <xsl:copy-of select="$alt-title" />
              </xsl:when>
              <xsl:when test="$mode='toc'">
                <xsl:apply-templates select="$title" mode="toc" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$title" />
              </xsl:otherwise>
            </xsl:choose>
          </fo:inline>
        </xsl:if>
      </xsl:when>
      <xsl:when test="$type='subsection'">
        <xsl:if test="$style!='title'">
          <fo:inline>
            <xsl:if test="$style='number'">
              <xsl:number count="subsection" />
            </xsl:if>
            <xsl:if test="$style='formatted' or $style='complete'">
              <xsl:number count="chapter | section | subsection" level="multiple" />
            </xsl:if>
          </fo:inline>
        </xsl:if>
        <xsl:if test="$style='title' or $style='complete'">
          <xsl:text></xsl:text>
          <fo:inline>
            <xsl:if test="not($mode)">
              <xsl:attribute name="axf:auto-letter-spacing">
                <xsl:value-of select="$auto-letter-spacing" />
              </xsl:attribute>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="not($title)">
                <xsl:copy-of select="$alt-title" />
              </xsl:when>
              <xsl:when test="$mode='toc'">
                <xsl:apply-templates select="$title" mode="toc" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$title" />
              </xsl:otherwise>
            </xsl:choose>
          </fo:inline>
        </xsl:if>
      </xsl:when>
      <xsl:when test="$type='figure'">
        <xsl:if test="$style!='title'">
          <fo:inline>
            <xsl:if test="$style='number'">
              <xsl:number count="figure" level="any" />
            </xsl:if>
            <xsl:if test="$style='formatted' or $style='complete'">
              <xsl:text>図.</xsl:text>
              <xsl:number count="figure" level="any" />
            </xsl:if>
          </fo:inline>
        </xsl:if>
        <xsl:if test="$style='title' or $style='complete'">
          <xsl:text></xsl:text>
          <xsl:apply-templates select="$title" />
        </xsl:if>
      </xsl:when>
      <xsl:when test="$type='table'">
        <xsl:if test="$style!='title'">
          <fo:inline>
            <xsl:if test="$style='number'">
              <xsl:number count="table" level="any" />
            </xsl:if>
            <xsl:if test="$style='formatted' or $style='complete'">
              <xsl:text>表.</xsl:text>
              <xsl:number count="table" level="any" />
            </xsl:if>
          </fo:inline>
        </xsl:if>
        <xsl:if test="$style='title' or $style='complete'">
          <xsl:text></xsl:text>
          <xsl:apply-templates select="$title" />
        </xsl:if>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="citation">
    <xsl:choose>
      <xsl:when test="@ref-id">
        <xsl:call-template name="process-citation">
          <xsl:with-param name="ref-node" select="//*[@id=current()/@ref-id]" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="process-citation" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="process-citation">
    <xsl:param name="ref-node" select="." />
    <xsl:variable name="type">
      <xsl:choose>
        <xsl:when test="@type">
          <xsl:value-of select="@type" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$ref-node[self::chapter]">
              <xsl:value-of select="'chapter'" />
            </xsl:when>
            <xsl:when test="$ref-node[self::section]">
              <xsl:value-of select="'section'" />
            </xsl:when>
            <xsl:when test="$ref-node[self::subsection]">
              <xsl:value-of select="'subsection'" />
            </xsl:when>
            <xsl:when test="$ref-node[self::figure]">
              <xsl:value-of select="'figure'" />
            </xsl:when>
            <xsl:when test="$ref-node[self::title]">
              <xsl:value-of select="'title'" />
            </xsl:when>
            <xsl:when test="$ref-node[self::li]">
              <xsl:value-of select="'li'" />
            </xsl:when>
            <xsl:otherwise>page</xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="style">
      <xsl:choose>
        <xsl:when test="@style">
          <xsl:value-of select="@style" />
        </xsl:when>
        <xsl:otherwise>complete</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="ref-id" select="@ref-id" />
    <xsl:for-each select="$ref-node">
      <xsl:choose>
        <xsl:when test="$type='chapter'">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type" select="$type" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="title" select="ancestor-or-self::chapter/title[1]" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$type='section'">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type" select="$type" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="title" select="ancestor-or-self::section/title[1]" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$type='subsection'">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type" select="$type" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="title" select="ancestor-or-self::subsection/title[1]" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$type='figure'">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type" select="$type" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="title" select="ancestor-or-self::figure/title[1]" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$type='table'">
          <xsl:call-template name="make-title-number">
            <xsl:with-param name="type" select="$type" />
            <xsl:with-param name="style" select="$style" />
            <xsl:with-param name="title" select="ancestor-or-self::table/title[1]" />
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="$type='list'">
          <xsl:for-each select="ancestor-or-self::li[1]">
            <xsl:call-template name="make-list-label">
              <xsl:with-param name="style" select="$style" />
            </xsl:call-template>
          </xsl:for-each>
        </xsl:when>
        <xsl:when test="$type='page'">
          <xsl:choose>
            <xsl:when test="$ref-id">
              <fo:page-number-citation ref-id="{$ref-id}" />
            </xsl:when>
            <xsl:otherwise>
              <fo:page-number />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="make-list-label">
    <xsl:param name="style" select="'complete'" />
    <fo:inline>
      <xsl:if test="not($style='number')">
        <xsl:attribute name="axf:number-transform">
          <xsl:choose>
            <xsl:when test="../@type">
              <xsl:value-of select="../@type" />
            </xsl:when>
            <xsl:when test="../self::ul">
              <xsl:variable name="nest" select="count(ancestor::ol | ancestor::ul)" />
              <xsl:choose>
                <xsl:when test="$nest=1">
                  <xsl:text>disc</xsl:text>
                </xsl:when>
                <xsl:when test="$nest=2">
                  <xsl:text>circle</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>square</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="../self::ol">
              <xsl:text>1.</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:attribute>
      </xsl:if>
      <xsl:number />
    </fo:inline>
  </xsl:template>
  <xsl:template name="make-toc">
    <xsl:if test="/doc/body/chapter">
      <fo:page-sequence master-reference="toc">
        <xsl:if test="not($new-chapter='new-page')">
          <xsl:attribute name="initial-page-number">auto-odd</xsl:attribute>
        </xsl:if>
        <xsl:call-template name="make-headerfooter" />
        <fo:flow flow-name="xsl-region-body">
          <fo:block id="{generate-id()}">
            <fo:block xsl:use-attribute-sets="toc">
              <xsl:call-template name="make-title">
                <xsl:with-param name="type">chapter</xsl:with-param>
                <xsl:with-param name="style">title</xsl:with-param>
                <xsl:with-param name="title" select="title[1]" />
                <xsl:with-param name="alt-title">
                  <xsl:call-template name="get-default-title" />
                </xsl:with-param>
              </xsl:call-template>
              <xsl:call-template name="make-toc-item-chapter" />
            </fo:block>
          </fo:block>
        </fo:flow>
      </fo:page-sequence>
    </xsl:if>
  </xsl:template>
  <xsl:template name="make-toc-item-chapter">
    <xsl:for-each select="/doc/body/chapter | /doc/back/index-page">
      <xsl:if test="*[1][self::title]or not(self::chapter)">
        <fo:block text-align="justify" text-align-last="justify" start-indent="{$toc-chapter-start-indent}">
          <fo:inline xsl:use-attribute-sets="toc-item" font-size="{$toc-chapter-font-size}" font-weight="{$toc-chapter-font-weight}">
            <xsl:call-template name="make-title-number">
              <xsl:with-param name="type">chapter</xsl:with-param>
              <xsl:with-param name="title" select="title[1]" />
              <xsl:with-param name="style">
                <xsl:if test="self::chapter">complete</xsl:if>
                <xsl:if test="not(self::chapter)">title</xsl:if>
              </xsl:with-param>
              <xsl:with-param name="alt-title">
                <xsl:call-template name="get-default-title" />
              </xsl:with-param>
              <xsl:with-param name="mode">toc</xsl:with-param>
            </xsl:call-template>
          </fo:inline>
          <xsl:call-template name="make-leader" />
          <xsl:call-template name="make-toc-pagenum" />
        </fo:block>
      </xsl:if>
      <xsl:if test="$toc-level='section' or $toc-level='subsection'">
        <xsl:call-template name="make-toc-item-section" />
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="make-toc-item-section">
    <xsl:for-each select="section">
      <xsl:if test="*[1][self::title]">
        <fo:block text-align="justify" text-align-last="justify" start-indent="{$toc-section-start-indent}">
          <fo:inline xsl:use-attribute-sets="toc-item" font-size="{$toc-section-font-size}" font-weight="{$toc-section-font-weight}">
            <xsl:call-template name="make-title-number">
              <xsl:with-param name="type">section</xsl:with-param>
              <xsl:with-param name="title" select="title[1]" />
              <xsl:with-param name="mode">toc</xsl:with-param>
            </xsl:call-template>
          </fo:inline>
          <xsl:call-template name="make-leader" />
          <xsl:call-template name="make-toc-pagenum" />
        </fo:block>
      </xsl:if>
      <xsl:if test="$toc-level='subsection'">
        <xsl:call-template name="make-toc-item-subsection" />
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="make-toc-item-subsection">
    <xsl:for-each select="subsection">
      <xsl:if test="*[1][self::title]">
        <fo:block text-align="justify" text-align-last="justify" start-indent="{$toc-subsection-start-indent}">
          <fo:inline xsl:use-attribute-sets="toc-item" font-size="{$toc-subsection-font-size}" font-weight="{$toc-subsection-font-weight}">
            <xsl:call-template name="make-title-number">
              <xsl:with-param name="type">subsection</xsl:with-param>
              <xsl:with-param name="title" select="title[1]" />
              <xsl:with-param name="mode">toc</xsl:with-param>
            </xsl:call-template>
          </fo:inline>
          <xsl:call-template name="make-leader" />
          <xsl:call-template name="make-toc-pagenum" />
        </fo:block>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="make-leader">
    <!--fo:leader leader-pattern="dots"/-->
    <fo:leader leader-pattern="use-content" leader-alignment="reference-area">･</fo:leader>
  </xsl:template>
  <xsl:template name="make-toc-pagenum">
    <fo:basic-link xsl:use-attribute-sets="toc-pagenum" internal-destination="{generate-id()}">
      <fo:page-number-citation ref-id="{generate-id()}" />
    </fo:basic-link>
  </xsl:template>
  <xsl:template match="title | a | i | b | u | index" mode="toc">
    <xsl:apply-templates select="a | i | b | u | img|ruby | index | text()" mode="toc" />
  </xsl:template>
  <xsl:template match="img" mode="toc" />
  <xsl:template match="ruby" mode="toc">
    <axf:ruby>
      <xsl:apply-templates select="rb | rt" mode="toc" />
    </axf:ruby>
  </xsl:template>
  <xsl:template match="rb" mode="toc">
    <axf:ruby-base>
      <xsl:value-of select="text()" />
    </axf:ruby-base>
  </xsl:template>
  <xsl:template match="rt" mode="toc">
    <axf:ruby-text>
      <xsl:value-of select="text()" />
    </axf:ruby-text>
  </xsl:template>
  <xsl:template name="make-index">
    <fo:page-sequence master-reference="index">
      <xsl:if test="not($new-chapter='new-page')">
        <xsl:attribute name="initial-page-number">auto-odd</xsl:attribute>
      </xsl:if>
      <xsl:call-template name="make-headerfooter" />
      <fo:flow flow-name="xsl-region-body">
        <fo:block id="{generate-id()}">
          <fo:block xsl:use-attribute-sets="index">
            <xsl:call-template name="make-title">
              <xsl:with-param name="type">chapter</xsl:with-param>
              <xsl:with-param name="style">title</xsl:with-param>
              <xsl:with-param name="title" select="title[1]" />
              <xsl:with-param name="alt-title">
                <xsl:call-template name="get-default-title" />
              </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="make-index-items" />
          </fo:block>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </xsl:template>
  <xsl:template match="index">
    <fo:inline index-key="{@key  | current()[not(@key)]}">
      <xsl:call-template name="apply-inlines" />
    </fo:inline>
  </xsl:template>
  <xsl:template name="make-index-items">
    <xsl:for-each select="//index">
      <xsl:sort select="@key| current()[not(@key)]" />
      <xsl:sort />
      <xsl:if test="not(.=preceding::index)">
        <fo:block text-align="justify" text-align-last="justify" start-indent="{$index-item-start-indent}">
          <fo:inline xsl:use-attribute-sets="index-item">
            <xsl:apply-templates mode="index" />
          </fo:inline>
          <xsl:call-template name="make-leader" />
          <fo:index-page-citation-list page-number-treatment="link" xsl:use-attribute-sets="index-pagenum">
            <fo:index-key-reference ref-index-key="{@key  | current()[not(@key)]}" />
          </fo:index-page-citation-list>
        </fo:block>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="a | i | b | u | index" mode="index">
    <xsl:apply-templates select="a | i | b | u | img | ruby |index |  text()" mode="index" />
  </xsl:template>
  <xsl:template match="img" mode="index" />
  <xsl:template match="ruby" mode="index">
    <xsl:value-of select="rb/text()" />
  </xsl:template>
  <xsl:template match="front">
    <xsl:apply-templates select="toc" />
  </xsl:template>
  <xsl:template match="back">
    <xsl:apply-templates select="index-page" />
  </xsl:template>
  <xsl:template match="toc">
    <xsl:call-template name="make-toc" />
  </xsl:template>
  <xsl:template match="index-page">
    <xsl:call-template name="make-index" />
  </xsl:template>
  <xsl:template name="get-default-title">
    <xsl:choose>
      <xsl:when test="self::toc">
        <xsl:text>目次</xsl:text>
      </xsl:when>
      <xsl:when test="self::index-page">
        <xsl:text>索引</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="ruby">
    <axf:ruby>
      <xsl:call-template name="process-common-attributes" />
      <xsl:apply-templates select="rb | rt" />
    </axf:ruby>
  </xsl:template>
  <xsl:template match="rb">
    <axf:ruby-base>
      <xsl:call-template name="process-common-attributes" />
      <xsl:value-of select="text()" />
    </axf:ruby-base>
  </xsl:template>
  <xsl:template match="rt">
    <axf:ruby-text>
      <xsl:call-template name="process-common-attributes" />
      <xsl:value-of select="text()" />
    </axf:ruby-text>
  </xsl:template>
</xsl:stylesheet>