/*
	XSL Formatter C Interface sample program

	The following indicates the standard sample for formatting XSL-FO
	document and outputting to PDF.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc_c.h>

void onMessageProc(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
{
	fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", errLevel, errCode, errMessage);
}

int main(int argc, char* argv[])
{
	int retCode = 0;
	CXfoObjPtr pObj = NULL;

	if (argc < 3) {
		printf("usage: sample.exe fo-file pdf-file\n");
		return 1;
	}

	pObj = xfo_createXfoObject();

	xfo_setOnMessageProc(pObj, onMessageProc);
	xfo_setExitLevel(pObj, ELVL_FATAL);
	xfo_setDocumentURI(pObj, argv[1]);
	xfo_setOutputFilePath(pObj, argv[2]);

	xfo_execute(pObj);
	if (xfo_getErrorCode(pObj) != 0) {
		char msg[256];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", xfo_getErrorLevel(pObj), xfo_getErrorCode(pObj), xfo_getErrorMessage(pObj, msg, sizeof(msg)));
		retCode = 1;
	} else {
		printf("Formatting finished: '%s' created\n", argv[2]);
	}
	xfo_releaseXfoObject(pObj);

	return retCode;
}
