/*
	XSL Formatter C Interface sample program

	The following sample indicates the sample for formatting FO and outputting
	to PDF by specifying XML document and XSLT stylesheet. XSLT transformation
	is done inside, PDF is outputted by formatting the generated XSL-FO. At
	that time, the generated XSL-FO is stored in the file specified by the
	third argument.

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc_c.h>

int main(int argc, char* argv[])
{
	int retCode = 0;
	CXfoObjPtr pObj = NULL;

	if (argc < 5) {
		printf("usage: sample2.exe xml-file xsl-file fo-file pdf-file\n");
		return 1;
	}

	pObj = xfo_createXfoObject();

	xfo_setErrorStreamType(pObj, EST_STDERR);
	xfo_setExitLevel(pObj, ELVL_FATAL);
	xfo_setDocumentURI(pObj, argv[1]);
	xfo_setStylesheetURI(pObj, argv[2]);
	xfo_setOutputFOPath(pObj, argv[3]);
	xfo_setOutputFilePath(pObj, argv[4]);

	xfo_execute(pObj);
	if (xfo_getErrorCode(pObj) != 0) {
		char msg[256];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", xfo_getErrorLevel(pObj), xfo_getErrorCode(pObj), xfo_getErrorMessage(pObj, msg, sizeof(msg)));
		retCode = 1;
	} else {
		printf("Formatting finished: '%s' created\n", argv[4]);
	}
	xfo_releaseXfoObject(pObj);

	return retCode;
}
