/*
	XSL Formatter C Interface sample program

	The following indicates the sample of formatting by loading the strings
	of XSL-FO specified as char format and outputting the formatted result
	to printer. The printer dialog will appear before printing, then it's
	possible to change the setting here.

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc_c.h>

void onMessageProc(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
{
	fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", errLevel, errCode, errMessage);
}

int main(int argc, char* argv[])
{
	int retCode = 0;
	CXfoObjPtr pObj = NULL;

	char szXmlText[] =
	"<?xml version='1.0'?> \
	<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" \
			 xmlns:axf=\"http://www.antennahouse.com/names/XSL/Extensions\"> \
		<fo:layout-master-set> \
			<fo:simple-page-master master-name=\"main\"> \
				<fo:region-body margin=\"2.5cm\"/> \
			</fo:simple-page-master> \
		</fo:layout-master-set> \
		<fo:page-sequence master-reference=\"main\"> \
			<fo:flow flow-name=\"xsl-region-body\"> \
			<fo:block> \
				XSL Formatter implements several extensions to the Specification, \
				placed into a separate namespace: \
				<fo:wrapper font-family=\"monospace\">xmlns:axf=\"http://www.antennahouse.com/names/XSL/Extensions\"</fo:wrapper> \
			</fo:block> \
			</fo:flow> \
		</fo:page-sequence> \
	</fo:root>";

	pObj = xfo_createXfoObject();
	xfo_setOnMessageProc(pObj, onMessageProc);
	xfo_setExitLevel(pObj, ELVL_FATAL);
	xfo_setDocumentText(pObj, szXmlText);
	xfo_setPrinterName(pObj, "@STDPRN");
	xfo_setBatchPrint(pObj, 0);

	xfo_execute(pObj);
	if (xfo_getErrorCode(pObj) != 0) {
		char msg[256];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", xfo_getErrorLevel(pObj), xfo_getErrorCode(pObj), xfo_getErrorMessage(pObj, msg, sizeof(msg)));
		retCode = 1;
	} else {
		printf("Formatting finished\n");
	}
	xfo_releaseXfoObject(pObj);

	return retCode;
}
