/*
	XSL Formatter C Interface sample program

	The following indicates the sample to use external XSLT processor for XSLT
	transformation and format the generated XSL-FO, output to PDF. The
	generated XSL-FO is stored in the file specified by the third argument.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc_c.h>

void onMessageProc(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
{
	fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", errLevel, errCode, errMessage);
}

int main(int argc, char* argv[])
{
	int retCode = 0;
	CXfoObjPtr pObj = NULL;

	if (argc < 5) {
		printf("usage: sample.exe xml-file xsl-file fo-file pdf-file\n");
		return 1;
	}

	pObj = xfo_createXfoObject();

	xfo_setOnMessageProc(pObj, onMessageProc);
	xfo_setExitLevel(pObj, ELVL_FATAL);
	xfo_setDocumentURI(pObj, argv[1]);
	xfo_setStylesheetURI(pObj, argv[2]);
	xfo_setOutputFOPath(pObj, argv[3]);
	xfo_setOutputFilePath(pObj, argv[4]);
	xfo_setExternalXSLT(pObj, "c:\\temp\\xalan\\Xalan %param -o %3 %1 %2");
	xfo_setXSLTParamFormat(pObj, "-p %p %v");

	xfo_execute(pObj);
	if (xfo_getErrorCode(pObj) != 0) {
		char msg[256];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %d\n message = %s\n", xfo_getErrorLevel(pObj), xfo_getErrorCode(pObj), xfo_getErrorMessage(pObj, msg, sizeof(msg)));
		retCode = 1;
	} else {
		printf("Formatting finished: '%s' created\n", argv[4]);
	}
	xfo_releaseXfoObject(pObj);

	return retCode;
}
