'
'	XSL Formatter COM Interface sample program
'
'	The following indicates the sample of formatting by loading the strings
'	of XSL-FO and outputting the formatted result to printer. The printer
'	dialog will appear before printing, then it's possible to change the
'	setting here.
'
'	Copyright 2004 Antenna House, Inc.
'
Dim obj
Dim domXML
On Error Resume Next

Set domXML = CreateObject("Msxml2.FreeThreadedDOMDocument.4.0")
If Err <> 0 Then
	Set domXML = CreateObject("Msxml2.FreeThreadedDOMDocument.3.0")
End If
domXML.async = False

Set obj = CreateObject("XfoComCtl.XfoObj")

domXML.LoadXML(_
	"<?xml version='1.0'?>" &_
	"<fo:root xmlns:fo='http://www.w3.org/1999/XSL/Format'" &_
	"		 xmlns:axf='http://www.antennahouse.com/names/XSL/Extensions'>" &_
	"	<fo:layout-master-set>" &_
	"		<fo:simple-page-master master-name='main'>" &_
	"			<fo:region-body margin='2.5cm'/>" &_
	"		</fo:simple-page-master>" &_
	"	</fo:layout-master-set>" &_
	"	<fo:page-sequence master-reference='main'>" &_
	"		<fo:flow flow-name='xsl-region-body'>" &_
	"		<fo:block>" &_
	"			XSL Formatter implements several extensions to the Specification," &_
	"			placed into a separate namespace:" &_
	"			<fo:wrapper font-family='monospace'>xmlns:axf='http://www.antennahouse.com/names/XSL/Extensions'</fo:wrapper>" &_
	"		</fo:block>" &_
	"		</fo:flow>" &_
	"	</fo:page-sequence>" &_
	"</fo:root>")

obj.XMLDOMDocument = domXML
obj.ExitLevel = 4
obj.PrinterName = "@STDPRN"
obj.BatchPrint = False

obj.Execute

If obj.ErrorCode <> 0 Then
	MsgBox "Formatting Error ----" & Chr(13) & "level = " & obj.ErrorLevel & Chr(13) &_
					"code = " & obj.ErrorCode & Chr(13) & "message = " & obj.ErrorMessage
Else
	MsgBox "Formatting finished"
End If

Set obj = Nothing
