/*
	XSL Formatter C++ Interface sample program

	The following indicates the standard sample for formatting XSL-FO
	document and outputting to PDF.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc.h>

using namespace XfoInterface;

class ErrDump : public MessageListener
{
	void onMessage(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
	{
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", errLevel, errCode, errMessage);
	}
};

int main(int argc, char* argv[])
{

	if (argc < 3) {
		printf("usage: sample.exe fo-file pdf-file\n");
		return 1;
	}

	XfoObj obj;
	ErrDump eDump;

	obj.setDocumentURI(argv[1]);
	obj.setOutputFilePath(argv[2]);
	obj.setMessageListener(&eDump);
	obj.setExitLevel(ELVL_FATAL);

	try {
		obj.execute();
		printf("Formatting finished: '%s' created\n", argv[2]);
	}
	catch (const XfoException &e) {
		char msg[2048];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", e.getErrorLevel(), e.getErrorCode(), e.getErrorMessage(msg, sizeof(msg)));
		return 1;
	}
	return 0;
}
