/*
	XSL Formatter C++ Interface sample program

	The following sample indicates the sample for formatting FO and outputting
	to PDF by specifying XML document and XSLT stylesheet. XSLT transformation
	is done inside, PDF is outputted by formatting the generated XSL-FO. At
	that time, the generated XSL-FO is stored in the file specified by the
	third argument.

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.

*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc.h>

using namespace XfoInterface;

int main(int argc, char* argv[])
{
	if (argc < 5) {
		printf("usage: sample2.exe xml-file xsl-file fo-file pdf-file\n");
		return 1;
	}

	XfoObj obj;

	obj.setErrorStreamType(EST_STDERR);
	obj.setDocumentURI(argv[1]);
	obj.setStylesheetURI(argv[2]);
	obj.setOutputFOPath(argv[3]);
	obj.setOutputFilePath(argv[4]);
	obj.setExitLevel(ELVL_FATAL);

	try {
		obj.execute();
		printf("Formatting finished: '%s' created\n", argv[4]);
	}
	catch (const XfoException &e) {
		char msg[2048];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", e.getErrorLevel(), e.getErrorCode(), e.getErrorMessage(msg, sizeof(msg)));
		return 1;
	}
	return 0;
}
