/*
	XSL Formatter C++ Interface sample program

	The following indicates the sample of formatting by loading the strings
	of XSL-FO and outputting the formatted result to printer. The printer
	dialog will appear before printing, then it's possible to change the
	setting here.

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.

*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc.h>

using namespace XfoInterface;

class ErrDump : public MessageListener
{
	void onMessage(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
	{
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", errLevel, errCode, errMessage);
	}
};

int main(int argc, char* argv[])
{
	XfoObj obj;
	ErrDump eDump;

	char szXmlText[] =
	"<?xml version='1.0'?> \
	<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" \
			 xmlns:axf=\"http://www.antennahouse.com/names/XSL/Extensions\"> \
		<fo:layout-master-set> \
			<fo:simple-page-master master-name=\"main\"> \
				<fo:region-body margin=\"2.5cm\"/> \
			</fo:simple-page-master> \
		</fo:layout-master-set> \
		<fo:page-sequence master-reference=\"main\"> \
			<fo:flow flow-name=\"xsl-region-body\"> \
			<fo:block> \
				XSL Formatter implements several extensions to the Specification, \
				placed into a separate namespace: \
				<fo:wrapper font-family=\"monospace\">xmlns:axf=\"http://www.antennahouse.com/names/XSL/Extensions\"</fo:wrapper> \
			</fo:block> \
			</fo:flow> \
		</fo:page-sequence> \
	</fo:root>";

	obj.setDocumentText(szXmlText);
	obj.setPrinterName("@STDPRN");
	obj.setMessageListener(&eDump);
	obj.setExitLevel(ELVL_FATAL);
	obj.setBatchPrint(0);

	try {
		obj.execute();
		printf("Formatting finished\n");
	}
	catch (const XfoException &e) {
		char msg[2048];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", e.getErrorLevel(), e.getErrorCode(), e.getErrorMessage(msg, sizeof(msg)));
		return 1;
	}
	return 0;
}
