/*
	XSL Formatter C++ Interface sample program

	The following indicates the sample to use external XSLT processor for XSLT
	transformation and format the generated XSL-FO, output to PDF. The
	generated XSL-FO is stored in the file specified by the third argument.

	Copyright 2004 Antenna House, Inc.
*/

#include <stdio.h>
#include <stdlib.h>
#include <xfoifc.h>

using namespace XfoInterface;

class ErrDump : public MessageListener
{
	void onMessage(XfoIfErrorLevel errLevel, XfoIfErrorCode errCode, const char* errMessage)
	{
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", errLevel, errCode, errMessage);
	}
};

int main(int argc, char* argv[])
{
	if (argc < 5) {
		printf("usage: sample.exe xml-file xsl-file fo-file pdf-file\n");
		return 1;
	}

	XfoObj obj;
	ErrDump eDump;

	obj.setMessageListener(&eDump);
	obj.setExitLevel(ELVL_FATAL);

	obj.setDocumentURI(argv[1]);
	obj.setStylesheetURI(argv[2]);
	obj.setOutputFOPath(argv[3]);
	obj.setOutputFilePath(argv[4]);
	obj.setExternalXSLT("c:\\temp\\xalan\\Xalan %param -o %3 %1 %2");
	obj.setXSLTParamFormat("-p %p %v");

	try {
		obj.execute();
		printf("Formatting finished: '%s' created\n", argv[4]);
	}
	catch (const XfoException &e) {
		char msg[2048];
		fprintf(stderr, "Formatting Error ----\n level = %d code = %ld\n message = %s\n", e.getErrorLevel(), e.getErrorCode(), e.getErrorMessage(msg, sizeof(msg)));
		return 1;
	}
	return 0;
}
