/*
     XSL Formatter .NET Interface sample program

     The following indicates the standard sample for formatting XSL-FO
     document and outputting to PDF.

     Copyright 2004 Antenna House, Inc.
*/

using System;
using System.Collections;
using XfoDotNetCtl;

public class MainApp
{
    static public void Main(string[] args)
    {
        if (args.Length < 2)
        {
            Console.WriteLine("usage: sample fo-file pdf-file");
            return;
        }

        XfoObj obj = null;
        try
        {
            obj = new XfoObj();
            obj.DocumentURI = args[0];
            obj.OutputFilePath = args[1];
            obj.ExitLevel = 4;
            obj.Execute();

            ArrayList errList = new ArrayList();
            obj.GetFormattingError(errList);
            for (int i = 0; i < errList.Count; i++)
            {
                XfoErrorInformation ei = (XfoErrorInformation)errList[i];
                Console.WriteLine("ErrorLevel : " + ei.ErrorLevel + "\nErrorCode  : " +
                ei.ErrorCode + "\n" + ei.ErrorMessage);
            }

            Console.WriteLine("\nFormatting finished: '" + args[1] + "' created.");
        }
        catch(XfoException e)
        {
            Console.WriteLine("ErrorLevel : " + e.ErrorLevel + "\nErrorCode : " + e.ErrorCode + "\n" + e.Message);
        }
        catch(Exception e)
        {
            Console.WriteLine(e.Message);
        }
        finally
        {
            if (obj != null)
                obj.Dispose();
        }
    }
}

