/*
     XSL Formatter .NET Interface sample program

     The following sample indicates the sample for formatting FO and outputting
     to printer by specifying XML document and XSLT stylesheet. The printer
     dialog will appear before printing, then it's possible to change the
     setting here. XSLT transformation is done inside, PDF is outputted by
     formatting the generated XSL-FO.

     This sample program is available only with Windows version.

     Copyright 2004 Antenna House, Inc.
*/

using System;
using XfoDotNetCtl;

public class MainApp
{
    static public void Main(string[] args)
    {
        if (args.Length < 2)
        {
            Console.WriteLine("usage: sample2 xml-file xsl-file");
            return;
        }

        XfoObj obj = null;
        try
        {
            obj = new XfoObj();
            obj.DocumentURI = args[0];
            obj.StylesheetURI = args[1];
            obj.PrinterName = "@STDPRN";
            obj.BatchPrint = false;
            obj.ErrorStreamType = 2;
            obj.ExitLevel = 4;
            obj.Execute();
            Console.WriteLine("Formatting finished.");
        }
        catch(XfoException e)
        {
            Console.WriteLine("ErrorLevel = " + e.ErrorLevel + "\nErrorCode = " + e.ErrorCode + "\n" + e.Message);
        }
        catch(Exception e)
        {
            Console.WriteLine(e.Message);
        }
        finally
        {
            if (obj != null)
                obj.Dispose();
        }
    }
}

