/*
     XSL Formatter .NET Interface sample program

     The following indicates the sample of formatting using render method.

     Copyright 2004 Antenna House, Inc.
*/

using System;
using System.IO;
using XfoDotNetCtl;

public class MainApp
{
    static public void Main(string[] args)
    {
        if (args.Length < 2)
        {
            Console.WriteLine("usage: sample3 fo-file pdf-file");
            return;
        }

        FileStream fs1 = null, fs2 = null;
        XfoObj obj = null;
        try
        {
            obj = new XfoObj();
            obj.ErrorStreamType = 2;
            obj.ExitLevel = 4;
            fs1 = File.Open(args[0], FileMode.Open, FileAccess.Read);
            fs2 = File.Open(args[1], FileMode.Create, FileAccess.ReadWrite);
            obj.Render(fs1, fs2);
            Console.WriteLine("Formatting finished: '" + args[1] + "' created.");
        }
        catch(XfoException e)
        {
            Console.WriteLine("ErrorLevel = " + e.ErrorLevel + "\nErrorCode = " + e.ErrorCode + "\n" + e.Message);
        }
        catch(Exception e)
        {
            Console.WriteLine(e.Message);
        }
        finally
        {
            if (fs2 != null)
                fs2.Close();
            if (fs1 != null)
                fs1.Close();
            if (obj != null)
                obj.Dispose();
        }
    }
}

