/*
     XSL Formatter .NET Interface sample program

     The following indicates the sample to use external XSLT processor for XSLT
     transformation and format the generated XSL-FO, output to PDF. The

     Copyright 2004 Antenna House, Inc.
*/

using System;
using XfoDotNetCtl;

public class MainApp
{
    static public void Main(string[] args)
    {
        if (args.Length < 3)
        {
            Console.WriteLine("usage: sample4 xml-file xsl-file pdf-file");
            return;
        }

        XfoObj obj = null;
        try
        {
            obj = new XfoObj();
            obj.DocumentURI = args[0];
            obj.StylesheetURI = args[1];
            obj.OutputFilePath = args[2];
            obj.ErrorStreamType = 2;
            obj.ExitLevel = 4;
            obj.ExternalXSLT = "c:\\temp\\xalan\\Xalan %param -o %3 %1 %2";
            obj.XSLTParamFormat = "-p %p %v";
            obj.Execute();
            Console.WriteLine("Formatting finished: '" + args[2] + "' created.");
        }
        catch(XfoException e)
        {
            Console.WriteLine("ErrorLevel = " + e.ErrorLevel + "\nErrorCode = " + e.ErrorCode + "\n" + e.Message);
        }
        catch(Exception e)
        {
            Console.WriteLine(e.Message);
        }
        finally
        {
            if (obj != null)
                obj.Dispose();
        }
    }
}

