/*
     XSL Formatter .NET Interface sample program

     The following indicates the sample to output PDF by ASP.NET and stream
     PDF directly to the Web browser.

     To use this sample program, set the SampleCtl_Click method as a event
     handler of arbitrary Web control on the Web form.

     Copyright 2004 Antenna House, Inc.
*/

using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;
using XfoDotNetCtl;

public class SamplePage : Page
{
    public void SampleCtl_Click(Object sender, EventArgs ea)
    {
        XfoObj obj = null;
        FileStream fs1 = null;
        try
        {
            obj = new XfoObj();
            obj.ExitLevel = 4;
            fs1 = File.Open("c:\\temp\\sample.fo", FileMode.Open, FileAccess.Read);
            Response.Clear();
            Response.Buffer = true;
            Response.ContentType = "application/pdf";
            Response.AppendHeader("Content-Disposition", "inline");
            Response.AppendHeader("Content-Transfer-Encoding", "base64");
            obj.Render(fs1, Response.OutputStream);
            Response.End();
        }
        catch(Exception e)
        {
            throw e;
        }
        finally
        {
            if (fs1 != null)
                fs1.Close();
            if (obj != null)
                obj.Dispose();
        }
    }
}
