/*
     XSL Formatter .NET Interface sample program

     The following indicates the sample of executing XSLT transformation and
     formatting separately and explicitly. The XslCompiledTransform method of
     .NET Framework is used for XSLT transformation.

     Copyright 2004 Antenna House, Inc.
*/

using System;
using System.IO;
using System.Xml.Xsl;
using System.Xml.XPath;
using XfoDotNetCtl;

public class MainApp
{
    static public void Main(string[] args)
    {
        if (args.Length < 3)
        {
            Console.WriteLine("usage: sample6 xml-file xsl-file pdf-file");
            return;
        }

        FileStream outFs = null;
        XfoObj obj = null;
        try
        {
            obj = new XfoObj();
            obj.ErrorStreamType = 2;
            obj.ExitLevel = 4;

            XslCompiledTransform xslt = new XslCompiledTransform();
            xslt.Load(args[1]);
            XPathDocument doc = new XPathDocument(args[0]);
            MemoryStream inFo = new MemoryStream();
            xslt.Transform(doc, null, inFo);
            outFs = File.Open(args[2], FileMode.Create, FileAccess.ReadWrite);
            obj.Render(inFo, outFs);
            Console.WriteLine("Formatting finished: '" + args[2] + "' created.");
        }
        catch(XfoException e)
        {
            Console.WriteLine("ErrorLevel = " + e.ErrorLevel + "\nErrorCode = " + e.ErrorCode + "\n" + e.Message);
        }
        catch(Exception e)
        {
            Console.WriteLine(e.Message);
        }
        finally
        {
            if (outFs != null)
                outFs.Close();
            if (obj != null)
                obj.Dispose();
        }
    }
}

