'
'   XSL Formatter .NET Interface sample program
'
'   The following indicates the standard sample for formatting XSL-FO
'   document and outputting to PDF.
'
'   Copyright 2004 Antenna House, Inc.

Imports System
Imports System.Collections
Imports Microsoft.VisualBasic
Imports XfoDotNetCtl

Module MainApp
    Sub Main(ByVal CmdArgs() As String)
        If CmdArgs.Length < 2 Then
            Console.WriteLine("usage: sample fo-file pdf-file")
            Return
        End If

        Dim obj As XfoObj
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.DocumentURI = CmdArgs(0)
            obj.OutputFilePath = CmdArgs(1)
            obj.ExitLevel = 4
            obj.Execute()
            Dim errList As New ArrayList()
            Dim i As Integer
            obj.GetFormattingError(errList)
            For i = 0 To errList.Count - 1
                Dim ei As XfoErrorInformation = errList(i)
                Console.WriteLine("ErrorLevel : " & ei.ErrorLevel & vbCrLf & "ErrorCode  : " & ei.ErrorCode & vbCrLf & ei.ErrorMessage)
            Next i
            Console.WriteLine("Formatting finished: '" & CmdArgs(1) & "' created.")
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Module

