'
'   XSL Formatter .NET Interface sample program
'
'   The following sample indicates the sample for formatting FO and outputting
'   to printer by specifying XML document and XSLT stylesheet. The printer
'   dialog will appear before printing, then it's possible to change the
'   setting here.  XSLT transformation is done inside, formats the generated
'   XSL-FO.
'
'   This sample program is available only with Windows version.
'
'   Copyright 2004 Antenna House, Inc.

Imports System
Imports Microsoft.VisualBasic
Imports XfoDotNetCtl

Module MainApp
    Sub Main(ByVal CmdArgs() As String)
        If CmdArgs.Length < 2 Then
            Console.WriteLine("usage: sample2 xml-file xsl-file")
            Return
        End If

        Dim obj As XfoObj
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.DocumentURI = CmdArgs(0)
            obj.StylesheetURI = CmdArgs(1)
            obj.PrinterName = "@STDPRN"
            obj.BatchPrint = False
            obj.ErrorStreamType = 2
            obj.ExitLevel = 4
            obj.Execute()
            Console.WriteLine(vbCrLf & "Formatting finished.")
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Module

