'
'   XSL Formatter .NET Interface sample program
'
'   The following indicates the sample of formatting using render method.
'
'   Copyright 2004 Antenna House, Inc.

Imports System
Imports System.IO
Imports Microsoft.VisualBasic
Imports XfoDotNetCtl

Module MainApp
    Sub Main(ByVal CmdArgs() As String)
        If CmdArgs.Length < 2 Then
            Console.WriteLine("usage: sample3 fo-file pdf-file")
            Return
        End If

        Dim fs1, fs2 As FileStream
        fs1 = Nothing
        fs2 = Nothing

        Dim obj As XfoObj
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.ErrorStreamType = 2
            obj.ExitLevel = 4
            fs1 = File.Open(CmdArgs(0), FileMode.Open, FileAccess.Read)
            fs2 = File.Open(CmdArgs(1), FileMode.Create, FileAccess.ReadWrite)
            obj.Render(fs1, fs2)
            Console.WriteLine(vbCrLf & "Formatting finished: '" & CmdArgs(1) & "' created.")
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If fs2 IsNot Nothing Then
                fs2.Close()
            End If
            If fs1 IsNot Nothing Then
                fs1.Close()
            End If
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Module

