'
'   XSL Formatter .NET Interface sample program
'
'   The following indicates the sample to use external XSLT processor for
'   XSLT transformation and format the generated XSL-FO, output to PDF. The
'
'   Copyright 2004 Antenna House, Inc.

Imports System
Imports Microsoft.VisualBasic
Imports XfoDotNetCtl

Module MainApp
    Sub Main(ByVal CmdArgs() As String)
        If CmdArgs.Length < 3 Then
            Console.WriteLine("usage: sample4 xml-file xsl-file pdf-file")
            Return
        End If

        Dim obj As XfoObj
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.DocumentURI = CmdArgs(0)
            obj.StylesheetURI = CmdArgs(1)
            obj.OutputFilePath = CmdArgs(2)
            obj.ErrorStreamType = 2
            obj.ExitLevel = 4
            obj.ExternalXSLT = "c:\temp\xalan\Xalan %param -o %3 %1 %2"
            obj.XSLTParamFormat = "-p %p %v"
            obj.Execute()
            Console.WriteLine(vbCrLf & "Formatting finished: '" & CmdArgs(2) & "' created.")
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Module

