'
'   XSL Formatter .NET Interface sample program
'
'   The following indicates the sample to output PDF by ASP.NET and stream
'   PDF directly to the Web browser.
'
'   To use this sample program, set the SampleCtl_Click method as a event
'   handler of arbitrary Web control on the Web form.
'
'   Copyright 2004 Antenna House, Inc.

Option Strict Off

Imports System
Imports System.IO
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports Microsoft.VisualBasic
Imports XfoDotNetCtl

Public Class SamplePage : Inherits Page

    Private Sub SampleCtl_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim obj As XfoObj
        Dim fs1 As FileStream
        fs1 = Nothing
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.ExitLevel = 4
            fs1 = File.Open("c:\temp\sample.fo", FileMode.Open, FileAccess.Read)
            Response.Clear()
            Response.Buffer = True
            Response.ContentType = "application/pdf"
            Response.AppendHeader("Content-Disposition", "inline")
            Response.AppendHeader("Content-Transfer-Encoding", "base64")
            obj.Render(fs1, Response.OutputStream)
            Response.End()
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If fs1 IsNot Nothing Then
                fs1.Close()
            End If
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Class
