'
'   XSL Formatter .NET Interface sample program
'
'   The following indicates the sample of executing XSLT transformation and
'   formatting separately and explicitly. The XslCompiledTransform method of
'   .NET Framework is used for XSLT transformation.
'
'   Copyright 2004 Antenna House, Inc.

Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Xml.Xsl
Imports System.Xml.XPath
Imports XfoDotNetCtl

Module MainApp
    Sub Main(ByVal CmdArgs() As String)
        If CmdArgs.Length < 3 Then
            Console.WriteLine("usage: sample6 xml-file xsl-file pdf-file")
            Return
        End If

        Dim outFs As FileStream
        outFs = Nothing

        Dim obj As XfoObj
        obj = Nothing
        Try
            obj = New XfoObj()
            obj.ErrorStreamType = 2
            obj.ExitLevel = 4
            Dim xslt As New XslCompiledTransform()
            xslt.Load(CmdArgs(1))
            Dim doc As New XPathDocument(CmdArgs(0))
            Dim inFo As New MemoryStream()
            xslt.Transform(doc, Nothing, inFo)
            outFs = File.Open(CmdArgs(2), FileMode.Create, FileAccess.ReadWrite)
            obj.Render(inFo, outFs)
            Console.WriteLine(vbCrLf & "Formatting finished: '" & CmdArgs(2) & "' created.")
        Catch ex As XfoException
            Console.WriteLine("ErrorLevel = " & ex.ErrorLevel & vbCrLf & "ErrorCode = " & ex.ErrorCode & vbCrLf & ex.Message)
        Catch ex As System.Exception
            Console.WriteLine(ex.Message)
        Finally
            If outFs IsNot Nothing Then
                outFs.Close()
            End If
            If obj IsNot Nothing Then
                obj.Dispose()
            End If
        End Try
    End Sub
End Module

