/*
	XSL Formatter Java Interface sample program

	The following indicates the standard sample for formatting XSL-FO
	document and outputting to PDF.

	Copyright 2004 Antenna House, Inc.
*/

import jp.co.antenna.XfoJavaCtl.*;

class ErrDump implements MessageListener {

	public void onMessage(int errLevel, int errCode, String errMessage) {
		System.out.println("ErrorLevel = " + errLevel + "\nErrorCode = " + errCode + "\n" + errMessage);
	}
}

public class sample {
	public static void main(String args []) {
		if (args.length < 2) {
			System.out.println("usage: java sample fo-file pdf-file");
			return;
		}

		XfoObj axfo = null;
		try {
			axfo = new XfoObj();
			ErrDump eDump = new ErrDump();
			axfo.setMessageListener(eDump);
			axfo.setDocumentURI(args[0]);
			axfo.setOutputFilePath(args[1]);
			axfo.setExitLevel(4);
			axfo.execute();
		}
		catch (XfoException e) {
			System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
			return;
		}
		finally
		{
			try {
				if (axfo != null)
					axfo.releaseObjectEx();
			}
			catch (XfoException e) {
				System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
				return;
			}
		}
		System.out.println("Formatting finished: '" + args[1] + "' created.");
	}
}
