/*
	XSL Formatter Java Interface sample program

	The following sample indicates the sample for formatting FO and outputting
	to printer by specifying XML document and XSLT stylesheet. The printer
	dialog will appear before printing. XSLT transformation is done inside,
	formats the generated XSL-FO.

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.
*/


import jp.co.antenna.XfoJavaCtl.*;

public class sample2 {
	public static void main(String args []) {
		if (args.length < 2) {
			System.out.println("usage: java sample xml-file xsl-file");
			return;
		}

		XfoObj axfo = null;
		try {
			axfo = new XfoObj();
			axfo.setErrorStreamType(axfo.S_EST_STDERR);
			axfo.setDocumentURI(args[0]);
			axfo.setStylesheetURI(args[1]);
			axfo.setPrinterName("@STDPRN");
			axfo.setBatchPrint(false);
			axfo.setExitLevel(4);
			axfo.execute();
		}
		catch (XfoException e) {
			System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
			return;
		}
		finally
		{
			try {
				if (axfo != null)
					axfo.releaseObjectEx();
			}
			catch (XfoException e) {
				System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
				return;
			}
		}
		System.out.println("Formatting finished.");
	}
}
