/*
	XSL Formatter Java Interface sample program

	The following indicates the sample of formatting using render method.

	Copyright 2004 Antenna House, Inc.
*/


import java.io.*;
import jp.co.antenna.XfoJavaCtl.*;

class ErrDump implements MessageListener {

	public void onMessage(int errLevel, int errCode, String errMessage) {
		System.out.println("ErrorLevel = " + errLevel + "\nErrorCode = " + errCode + "\n" + errMessage);
	}
}

public class sample3 {
	public static void main(String args []) {
		if (args.length < 2) {
			System.out.println("usage: java sample fo-file pdf-file");
			return;
		}

		XfoObj axfo = null;
		FileInputStream is = null;
		FileOutputStream os = null;
		try {
			axfo = new XfoObj();
			ErrDump eDump = new ErrDump();
			axfo.setMessageListener(eDump);
			axfo.setExitLevel(4);

			is = new FileInputStream(args[0]);
			os = new FileOutputStream(args[1]);
			axfo.render(is, os, "@PDF");
		}
		catch (XfoException e) {
			System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
			return;
		}
	    catch (Exception e)
	    {
			e.printStackTrace();
			return;
		}
		finally
		{
			try {
				if (axfo != null)
					axfo.releaseObjectEx();
			}
			catch (XfoException e) {
				System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
				return;
			}
			try {
				is.close();
			} catch (Exception e) {}
			try {
				os.close();
			} catch (Exception e) {}
		}
		System.out.println("Formatting finished: '" + args[1] + "' created.");
	}
}
