/*
	XSL Formatter Java Interface sample program

	The following indicates the sample to use external XSLT processor for XSLT
	transformation and format the generated XSL-FO, output to PDF. The

	This sample program is available only with Windows version.

	Copyright 2004 Antenna House, Inc.
*/


import jp.co.antenna.XfoJavaCtl.*;

class ErrDump implements MessageListener {

	public void onMessage(int errLevel, int errCode, String errMessage) {
		System.out.println("ErrorLevel = " + errLevel + "\nErrorCode = " + errCode + "\n" + errMessage);
	}
}

public class sample4 {
	public static void main(String args []) {
		if (args.length < 3) {
			System.out.println("usage: java sample xml-file xsl-file pdf-file");
			return;
		}

		XfoObj axfo = null;
		try {
			axfo = new XfoObj();
			ErrDump eDump = new ErrDump();
			axfo.setMessageListener(eDump);
			axfo.setDocumentURI(args[0]);
			axfo.setStylesheetURI(args[1]);
			axfo.setOutputFilePath(args[2]);
			axfo.setExternalXSLT("c:\\temp\\xalan\\Xalan %param -o %3 %1 %2");
			axfo.setXSLTParamFormat("-p %p %v");
			axfo.setExitLevel(4);
			axfo.execute();
		}
		catch (XfoException e) {
			System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
			return;
		}
		finally
		{
			try {
				if (axfo != null)
					axfo.releaseObjectEx();
			}
			catch (XfoException e) {
				System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
				return;
			}
		}
		System.out.println("Formatting finished: '" + args[2] + "' created.");
	}
}
