/*
	XSL Formatter Java Interface sample program

	The following indicates the sample of formatting using render method.

	Copyright 2004-2008 Antenna House, Inc.
*/


import java.io.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import jp.co.antenna.XfoJavaCtl.*;

class ErrDump implements MessageListener {

	public void onMessage(int errLevel, int errCode, String errMessage) {
		System.out.println("ErrorLevel = " + errLevel + "\nErrorCode = " + errCode + "\n" + errMessage);
	}
}

public class sample5 {
	public static void main(String args []) {
		if (args.length < 3) {
			System.out.println("usage: java sample xml-file xsl-file pdf-file");
			return;
		}

		XfoObj axfo = null;
		FileInputStream fisXml = null;
		FileInputStream fisXsl = null;
		FileOutputStream fosFo=null;
		FileInputStream fisFo=null;
		FileOutputStream fosPdf = null;
		File tempFo=null;
		try {
			axfo = new XfoObj();
			ErrDump eDump = new ErrDump();
			axfo.setMessageListener(eDump);
			axfo.setExitLevel(4);

			fisXml = new FileInputStream(args[0]);
			fisXsl = new FileInputStream(args[1]);
			tempFo=File.createTempFile("temp_",".fo");
			fosFo = new FileOutputStream(tempFo);
			fosPdf = new FileOutputStream(args[2]);

			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer(new StreamSource(fisXsl));
			transformer.transform(new StreamSource(fisXml), new StreamResult(fosFo));

			fisFo = new FileInputStream(tempFo);
			axfo.render(fisFo, fosPdf, "@PDF");
		}
		catch (XfoException e) {
			System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
			return;
		}
	    catch (Exception e)
	    {
			e.printStackTrace();
			return;
		}
		finally
		{
			try {
				if (axfo != null)
					axfo.releaseObjectEx();
			}
			catch (XfoException e) {
				System.out.println("ErrorLevel = " + e.getErrorLevel() + "\nErrorCode = " + e.getErrorCode() + "\n" + e.getErrorMessage());
				return;
			}
			try {
				fisXml.close();
			} catch (Exception e) {}
			try {
				fisXsl.close();
			} catch (Exception e) {}
			try {
				fosPdf.close();
			} catch (Exception e) {}
			try {
				tempFo.delete();
			} catch (Exception e) {}
		}
		System.out.println("Formatting finished: '" + args[2] + "' created.");
	}
}
