<?xml version="1.0" encoding="UTF-8" ?>
<!--                      sdoc2fo.xsl                                -->
<!--              Original: author Hiroshi Obata                       --><!--              Original: Copyright Antenna House, Inc.                      -->
<!--                      version 1.0                                -->
<!-- Redistribution and use with or without modification, are permitted to anybody.                               -->
<xsl:stylesheet version="1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml"
            version="1.0"
            indent="no" />

<!-- Control -->
<xsl:param name="toc-make" select="true()"/>

<!-- Paper Size -->
<xsl:param name="paper-width" >210mm</xsl:param>
<xsl:param name="paper-height">
297mm
</xsl:param>
<!-- indent -->
<xsl:param name="basic-start-indent">10mm</xsl:param>
<xsl:param name="basic-end-indent">10mm</xsl:param>


<!-- Cover Style -->
<xsl:attribute-set name="cover-style">
	<xsl:attribute name="text-align">center</xsl:attribute>
</xsl:attribute-set>
<!-- doc-title -->
<xsl:attribute-set name="h1.title" >
	<xsl:attribute name="font-size">24pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>	
	<xsl:attribute name="color">maroon</xsl:attribute>
	<xsl:attribute name="background-color">gold</xsl:attribute>
	<xsl:attribute name="border-style">outset</xsl:attribute>
	<xsl:attribute name="border-color">yellow</xsl:attribute>
	<xsl:attribute name="padding">10pt</xsl:attribute>
	<xsl:attribute name="margin-left">60pt</xsl:attribute>
	<xsl:attribute name="margin-right">60pt</xsl:attribute>
	<xsl:attribute name="space-before">1em</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>

</xsl:attribute-set>

<!-- part title -->
<xsl:attribute-set name="h1.part" >
	<xsl:attribute name="font-size">30pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="space-before">1em</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="h1.chapter" >
	<xsl:attribute name="font-size">24pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="space-before">1em</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="h2" >
	<xsl:attribute name="font-size">18pt</xsl:attribute>
	<xsl:attribute name="space-before">1em</xsl:attribute>
	<xsl:attribute name="space-before.precedence">1</xsl:attribute>
	<xsl:attribute name="space-after">1em</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute><xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="h3" >
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
	<xsl:attribute name="font-size">14pt</xsl:attribute>
	<xsl:attribute name="space-before">0.5em</xsl:attribute>
	<xsl:attribute name="space-before.precedence">1</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="top.h3" >
	<xsl:attribute name="font-size">14pt</xsl:attribute>
	<xsl:attribute name="space-before">0.5em</xsl:attribute>
	<xsl:attribute name="space-before.precedence">1</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="h4" >
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
	<xsl:attribute name="color">black</xsl:attribute>
	<xsl:attribute name="font-size">12pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="space-before.precedence">1</xsl:attribute>
	<xsl:attribute name="space-before">0.5em</xsl:attribute>
	<xsl:attribute name="space-after">0.5em</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="dfn" >
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="font-style">normal</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="code" >
	<xsl:attribute name="font-family">helvetica, sans-serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="table.data" >
	<xsl:attribute name="table-layout">fixed</xsl:attribute>
	<xsl:attribute name="space-before">10pt</xsl:attribute>
	<xsl:attribute name="space-after">10pt</xsl:attribute>
	<xsl:attribute name="background-color">green</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="table.data.tbody" >
	<xsl:attribute name="background-color">green</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="table.data.caption" >
<xsl:attribute name="start-indent">
<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="background-color">khaki</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-style">ridge</xsl:attribute>
	<xsl:attribute name="text-align">start</xsl:attribute>
	
</xsl:attribute-set>

<xsl:attribute-set name="table.data.th" >
	<xsl:attribute name="color">yellow</xsl:attribute>
	<xsl:attribute name="background-color">#20C2AA</xsl:attribute>
	<xsl:attribute name="border-style">ridge</xsl:attribute>
	<xsl:attribute name="border-color">green</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="table.data.td" >
	<xsl:attribute name="background-color">#FEEBD7</xsl:attribute>
	<xsl:attribute name="border-style">ridge</xsl:attribute>
	<xsl:attribute name="border-color">green</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="dt" >
	<xsl:attribute name="font-weight">bold</xsl:attribute><xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="dd" >
		<xsl:attribute name="space-before">0.3em</xsl:attribute>
<xsl:attribute name="space-after">0.5em</xsl:attribute><xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	+ 4em</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>

</xsl:attribute-set>

<xsl:attribute-set name="figure.title" >
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-before">3pt</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="program.title" >
	<xsl:attribute name="font-family">sans-serif</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-before">3pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
	<xsl:attribute name="keep-with-next.within-page">always</xsl:attribute>

</xsl:attribute-set>

<!-- body -->

<!-- p-->
<xsl:attribute-set name="p">
	<xsl:attribute name="text-indent">1em</xsl:attribute>
	<xsl:attribute name="space-before">0.6em</xsl:attribute>
	<xsl:attribute name="space-after">0.6em</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
</xsl:attribute-set>
<!-- p-->
<xsl:attribute-set name="top.p">
	<xsl:attribute name="text-indent">1em</xsl:attribute>
	<xsl:attribute name="space-before">0.6em</xsl:attribute>
	<xsl:attribute name="space-after">0.6em</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="dd.p">
	<xsl:attribute name="text-indent">1em</xsl:attribute>
</xsl:attribute-set>


<xsl:attribute-set name="program">
	<xsl:attribute name="white-space">pre</xsl:attribute>
	<xsl:attribute name="wrap-option">wrap</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
	<xsl:attribute name="background-color">gainsboro</xsl:attribute>
	<xsl:attribute name="font-family">monospace</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="console">
	<xsl:attribute name="white-space">pre</xsl:attribute>
	<xsl:attribute name="wrap-option">wrap</xsl:attribute>
	<xsl:attribute name="background-color">black</xsl:attribute>
	<xsl:attribute name="color">white</xsl:attribute>
	<xsl:attribute name="margin">5pt</xsl:attribute>
	<xsl:attribute name="margin-right">30pt</xsl:attribute>
	<xsl:attribute name="font-family">monospace</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="result" >
	<xsl:attribute name="background-color">ivory</xsl:attribute>
	<xsl:attribute name="border-style">inset</xsl:attribute>
	<xsl:attribute name="border-color">gold</xsl:attribute>
	<xsl:attribute name="margin">10pt</xsl:attribute>
	<xsl:attribute name="space-before">10pt</xsl:attribute>
	<xsl:attribute name="space-after">10pt</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>


<xsl:attribute-set name="note" >
	<xsl:attribute name="background-color">antiquewhite</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="div.comment" >
	<xsl:attribute name="color">red</xsl:attribute>
	<xsl:attribute name="background-color">yellow</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="div.toc" >
	<xsl:attribute name="border-style">inset</xsl:attribute>
	<xsl:attribute name="border-width">thick</xsl:attribute>
	<xsl:attribute name="border-color">cornsilk</xsl:attribute>
	<xsl:attribute name="background-color">cornsilk</xsl:attribute>
	<xsl:attribute name="margin">10pt</xsl:attribute>
	<xsl:attribute name="space-before">10pt</xsl:attribute>
	<xsl:attribute name="space-after">30pt</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="blockquote" >
	<xsl:attribute name="background-color">gray</xsl:attribute>
	<xsl:attribute name="font-style">italic</xsl:attribute>
	<xsl:attribute name="margin">10pt</xsl:attribute>
	<xsl:attribute name="space-before">10pt</xsl:attribute>
	<xsl:attribute name="space-after">10pt</xsl:attribute>
	<xsl:attribute name="start-indent">
		<xsl:value-of select="$basic-start-indent"/>
	</xsl:attribute>
	<xsl:attribute name="end-indent">
		<xsl:value-of select="$basic-end-indent"/>
	</xsl:attribute>
</xsl:attribute-set>

<!-- inline-->
<xsl:attribute-set name="em" >
	<xsl:attribute name="font-weight">bold</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="q" >
	<xsl:attribute name="font-style">italic</xsl:attribute>
</xsl:attribute-set>

<!-- Content Transform-->
<xsl:template match="doc">
	<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<fo:layout-master-set>
	<fo:simple-page-master margin-top="5mm" margin-bottom="5mm" margin-right="5mm" margin-left="10mm"  master-name="PageMaster">
	<xsl:attribute name="page-height">
		<xsl:value-of select="$paper-height"/>
	</xsl:attribute>
	<xsl:attribute name="page-width">
		<xsl:value-of select="$paper-width"/>
	</xsl:attribute>
	<fo:region-body   margin-top="8mm" margin-right="8mm" margin-bottom="8mm" margin-left="8mm"/>
	<fo:region-before  border-after-style="solid" border-width="thin" extent="5mm" display-align="after"/>
	<fo:region-after  border-before-style="solid" border-width="thin" extent="5mm" display-align="before"/>
	<fo:region-start   reference-orientation="270" extent="5mm"/>
	<fo:region-end    reference-orientation="90"  extent="5mm"/>
	</fo:simple-page-master>


	<fo:simple-page-master  margin-top="5mm" margin-bottom="5mm" margin-right="5mm" margin-left="10mm" master-name="PageMaster-Cover">
	<xsl:attribute name="page-height">
		<xsl:value-of select="$paper-height"/>
	</xsl:attribute>
	<xsl:attribute name="page-width">
		<xsl:value-of select="$paper-width"/>
	</xsl:attribute>
	<fo:region-body  margin-top="8mm" margin-right="8mm" margin-bottom="8mm" margin-left="8mm"/>
	</fo:simple-page-master>
	<fo:simple-page-master margin-top="5cm" margin-bottom="5mm" margin-right="5mm" margin-left="10mm"  master-name="PageMaster-Top">
	<xsl:attribute name="page-height">
		<xsl:value-of select="$paper-height"/>
	</xsl:attribute>
	<xsl:attribute name="page-width">
		<xsl:value-of select="$paper-width"/>
	</xsl:attribute>

	<fo:region-body  margin-top="8mm" margin-right="8mm" margin-bottom="8mm" margin-left="8mm"/><fo:region-after extent="5mm"/>
	</fo:simple-page-master>
	</fo:layout-master-set>
	<xsl:apply-templates select="head" /><xsl:if test="$toc-make"><xsl:call-template name="toc" /></xsl:if>
	<xsl:apply-templates select="body" />
	</fo:root>
</xsl:template>

<xsl:template match="doc/head">
	<fo:page-sequence master-reference="PageMaster-Top">
	<fo:static-content flow-name="xsl-region-after">
	</fo:static-content>
	<fo:flow flow-name="xsl-region-body" >
		<fo:block space-after="7.5cm" space-after.precedence="1" xsl:use-attribute-sets="cover-style">
		<xsl:apply-templates select="/doc/head/title"/>
		</fo:block>
		<fo:block   xsl:use-attribute-sets="cover-style">
		<xsl:apply-templates select="/doc/head/author"/>
		<xsl:apply-templates select="/doc/head/date"/>
		</fo:block>
	</fo:flow>
	</fo:page-sequence>
</xsl:template>

  
<xsl:template match="doc/head/title">
	<fo:block xsl:use-attribute-sets="h1.title">
	<xsl:apply-templates />
	</fo:block>
</xsl:template>

<xsl:template match="doc/head/author">
	<fo:block space-before="1em" space-after="1em" xsl:use-attribute-sets="top.h3">
		<xsl:apply-templates />
	</fo:block>
</xsl:template>

<xsl:template match="doc/head/hp">
	<fo:block xsl:use-attribute-sets="top.h3">
		<xsl:apply-templates />
	</fo:block>
</xsl:template>

<xsl:template match="doc/head/date">
	<fo:block  xsl:use-attribute-sets="top.h3">
		<xsl:apply-templates />
	</fo:block>
</xsl:template>

<xsl:template match="doc/head/abstract">
	<fo:block xsl:use-attribute-sets="top.p">
		<xsl:apply-templates />
	</fo:block>
</xsl:template>

<xsl:template name="toc">
	<fo:page-sequence master-reference="PageMaster-Cover">
	<fo:flow flow-name="xsl-region-body" >
		<fo:block xsl:use-attribute-sets="div.toc">
		<fo:block xsl:use-attribute-sets="h2">Table of Contents</fo:block>
		<xsl:for-each select="//part | //chapter | //section | //subsection">
			<xsl:apply-templates select="." mode="toc"/>
		</xsl:for-each>
		</fo:block>
	</fo:flow>
	</fo:page-sequence>
</xsl:template>

<xsl:template match="part|chapter|section|subsection" mode="toc">
	<xsl:variable name="level" select="count(ancestor-or-self::part | 
                                           ancestor-or-self::chapter |
                                           ancestor-or-self::section |
                                           ancestor-or-self::subsection )" />
	<fo:block  text-align-last="justify">
	<xsl:attribute name="margin-left">
	<xsl:choose>
		<xsl:when test="$level=1">0em</xsl:when>
		<xsl:when test="$level=2">1em</xsl:when>
		<xsl:when test="$level=3">2em</xsl:when>
		<xsl:otherwise>4em</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>

	<xsl:attribute name="space-before">
	<xsl:choose>
		<xsl:when test="$level=1">5pt</xsl:when>
		<xsl:when test="$level=2">3pt</xsl:when>
		<xsl:when test="$level=3">1pt</xsl:when>
		<xsl:otherwise>1pt</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>
	<xsl:attribute name="font-size">
	<xsl:choose>
		<xsl:when test="$level=1">large</xsl:when>
		<xsl:when test="$level=2">medium</xsl:when>
		<xsl:when test="$level=3">small</xsl:when>
		<xsl:otherwise>x-small</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>

	<xsl:attribute name="font-weight">
	<xsl:choose>
		<xsl:when test="$level=1">bold</xsl:when>
		<xsl:when test="$level=2">bold</xsl:when>
		<xsl:when test="$level=3">normal</xsl:when>
		<xsl:otherwise>normal</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>

	<xsl:value-of select="title" />
	<fo:leader leader-pattern="dots"/>
		<xsl:choose><xsl:when test="@id"><fo:page-number-citation ref-id="@id"/>
	</xsl:when>
		<xsl:otherwise>
		<fo:page-number-citation ref-id="{generate-id()}"/>
		</xsl:otherwise>
	</xsl:choose>
	</fo:block>
</xsl:template>


<xsl:template match="body">
	<fo:page-sequence master-reference="PageMaster">
	<fo:static-content flow-name="xsl-region-before">
		<fo:block text-align="center" font-size="small">
		<xsl:if test="/doc/head/title">
			<xsl:value-of select="/doc/head/title"/>
		</xsl:if>
		</fo:block>
	</fo:static-content>
	<fo:static-content flow-name="xsl-region-after">
	<fo:block text-align="center" font-size="small">
		- <fo:page-number/> -
	</fo:block>
	</fo:static-content>
	<fo:static-content flow-name="xsl-region-start">
	<fo:block text-align="center" font-size="small">
	</fo:block>
	</fo:static-content>
	<fo:static-content flow-name="xsl-region-end">
	<fo:block text-align="center" font-size="small">
	</fo:block>
	</fo:static-content>
	<fo:static-content flow-name="xsl-footnote-separator">
	<fo:block>
		<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="33%"/>
	</fo:block>
	</fo:static-content>

	<fo:flow flow-name="xsl-region-body" >
		<fo:block>
		<xsl:apply-templates />
		</fo:block>
	</fo:flow>
	</fo:page-sequence></xsl:template>

<xsl:template match="part">
	<fo:block xsl:use-attribute-sets="h1.part" id="{generate-id()}">
	<xsl:if test="@id">
	<xsl:attribute name="id">
		<xsl:value-of select="@id"/>
	</xsl:attribute>
	</xsl:if>
	<xsl:value-of select="title"/>
	</fo:block>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="part/title">
</xsl:template>

<xsl:template match="chapter">
	<fo:block xsl:use-attribute-sets="h1.chapter" id="{generate-id()}">
	<xsl:if test="@id">
		<xsl:attribute name="id">
		<xsl:value-of select="@id"/>
		</xsl:attribute>
	</xsl:if>
	<xsl:value-of select="title" />
	</fo:block>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="chapter/title">
</xsl:template>

<xsl:template match="section">
	<fo:block xsl:use-attribute-sets="h2" id="{generate-id()}">
	<xsl:if test="@id">
		<xsl:attribute name="id">
		<xsl:value-of select="@id"/>
		</xsl:attribute>
	</xsl:if>
	<xsl:value-of select="title"/>
	</fo:block>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="section/title">
</xsl:template>

<xsl:template match="subsection">
	<fo:block xsl:use-attribute-sets="h3" id="{generate-id()}">
		<xsl:value-of select="title"/>
	</fo:block>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="subsection/title">
</xsl:template>

<xsl:template match="subsubsection">
	<fo:block xsl:use-attribute-sets="h4">
	<xsl:value-of select="title"/>
	</fo:block>
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="subsubsection/title">
</xsl:template>

<xsl:template match="p">
	<fo:block xsl:use-attribute-sets="p"><xsl:apply-templates /></fo:block>
</xsl:template>

<xsl:template match="sen"><xsl:apply-templates /></xsl:template>

<xsl:template match="appendix"><xsl:apply-templates /></xsl:template>

<xsl:template match="fyi"><xsl:apply-templates /></xsl:template>

<xsl:template match="figure">
	<fo:block text-align="center">
		<fo:external-graphic src="{@src}"/>
	</fo:block>
	<fo:block xsl:use-attribute-sets="figure.title">
	<xsl:value-of select="title" />
	</fo:block>
</xsl:template>

<xsl:template match="img"><xsl:apply-templates /></xsl:template>

<xsl:template match="ul">
	<fo:list-block provisional-distance-between-starts="15mm"  provisional-label-separation="5mm" xsl:use-attribute-set="p">
	<xsl:apply-templates/>
	</fo:list-block>
</xsl:template>

<xsl:template match="ul/li">
	<xsl:variable name="list-level" select="count(ancestor-or-self::ul | 
                                           ancestor-or-self::ol |
                                           ancestor-or-self::dl )" />
	<fo:list-item>
	<fo:list-item-label  end-indent="label-end()">
	<xsl:attribute name="start-indent">
	<xsl:choose>
		<xsl:when test="$list-level=1">
		<xsl:value-of select="$basic-start-indent" />
		</xsl:when>
		<xsl:otherwise>inherit + 5 mm</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>
	<fo:block>
	&#x2022;
	</fo:block>
	</fo:list-item-label>
	<fo:list-item-body start-indent="body-start()" text-align="justify" end-indent="{$basic-end-indent}">
		<fo:block>
			<xsl:apply-templates/>
		</fo:block>
	</fo:list-item-body>
	</fo:list-item>
</xsl:template>

  
<xsl:template match="ol">
  <fo:list-block provisional-distance-between-starts="15mm"
   provisional-label-separation="5mm">
    <xsl:apply-templates select="li"/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ol/li">
	<xsl:variable name="list-level" select="count(ancestor-or-self::ul | 
                                           ancestor-or-self::ol |
                                           ancestor-or-self::dl )" />

	<fo:list-item >
	<fo:list-item-label  end-indent="label-end()">	<xsl:attribute name="start-indent">
	<xsl:choose>
		<xsl:when test="$list-level=1">
		<xsl:value-of select="$basic-start-indent" />
		</xsl:when>
		<xsl:otherwise>inherit + 5 mm</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>

	<fo:block ><xsl:number format="1."/></fo:block>
	</fo:list-item-label>
	<fo:list-item-body start-indent="body-start()" end-indent="{$basic-end-indent}" text-align="justify" >
	<fo:block>
		<xsl:apply-templates/>
	</fo:block>
	</fo:list-item-body>
	</fo:list-item>
</xsl:template>
  

<xsl:template match="dl">
<xsl:apply-templates />

</xsl:template>

<xsl:template match="dt">
<fo:block xsl:use-attribute-sets="dt">
<xsl:apply-templates />
</fo:block>
</xsl:template>

<xsl:template match="dd">
<fo:block xsl:use-attribute-sets="dd">
<xsl:apply-templates />
</fo:block>
</xsl:template>


  <xsl:template match="dd/p">
<fo:block xsl:use-attribute-sets="dd.p">
<xsl:apply-templates />
</fo:block>
</xsl:template>

  <xsl:template match="table/tltle"></xsl:template>

  <xsl:template match="table"><fo:table-and-caption start-indent="{$basic-start-indent}" ><xsl:if test="title"><fo:table-caption xsl:use-attribute-sets="table.data.caption"><fo:block start-indent="0"><xsl:value-of select="title"/></fo:block>
</fo:table-caption>
</xsl:if>
			<fo:table xsl:use-attribute-sets="table.data">
<xsl:apply-templates />							</fo:table>
		</fo:table-and-caption>
</xsl:template>


  <xsl:template match="rowgroup"><xsl:apply-templates /></xsl:template>

  <xsl:template match="colgroup"><fo:table-column>    <xsl:if test="@span">
      <xsl:attribute name="number-columns-spanned">
        <xsl:value-of select="@span"/>
      </xsl:attribute>
    </xsl:if>
 </fo:table-column></xsl:template>

  <xsl:template match="col">    </xsl:template>

  <xsl:template match="thead"><fo:table-header xsl:use-attribute-sets="table.data.tbody"><xsl:apply-templates />
</fo:table-header>
</xsl:template>

  <xsl:template match="tfoot"><xsl:apply-templates /></xsl:template>

  <xsl:template match="tbody"><fo:table-body xsl:use-attribute-sets="table.data.tbody"><xsl:apply-templates />
</fo:table-body>
</xsl:template>

  <xsl:template match="tr"><fo:table-row><xsl:apply-templates /></fo:table-row>
</xsl:template>

  <xsl:template match="th"><fo:table-cell xsl:use-attribute-sets="table.data.th"><fo:block ><xsl:apply-templates /></fo:block>
</fo:table-cell>
</xsl:template>

  <xsl:template match="td"><fo:table-cell xsl:use-attribute-sets="table.data.td">
   <xsl:if test="@colspan">
      <xsl:attribute name="number-columns-spanned">
        <xsl:value-of select="@colspan"/>
      </xsl:attribute>
</xsl:if>

<fo:block ><xsl:apply-templates /></fo:block>
</fo:table-cell>
</xsl:template>

<xsl:template match="@colspan"><fo:table-cell xsl:use-attribute-sets="table.data.td"><fo:block ><xsl:apply-templates /></fo:block>
</fo:table-cell>
</xsl:template>

  <xsl:template match="tnote"><xsl:apply-templates /></xsl:template>

  <xsl:template match="pre"><xsl:apply-templates /></xsl:template>

  <xsl:template match="program">
<xsl:apply-templates select="title"/>
<fo:block xsl:use-attribute-sets="program"><xsl:apply-templates select="text()"/></fo:block>
</xsl:template>

<xsl:template match="program/title">
<fo:block xsl:use-attribute-sets="program.title">
<xsl:apply-templates /></fo:block>
</xsl:template>

  <xsl:template match="console"><fo:block xsl:use-attribute-sets="console"><xsl:apply-templates /></fo:block>
</xsl:template>

  <xsl:template match="div"><fo:block><xsl:apply-templates /></fo:block>
</xsl:template>

<xsl:template match="div[@class = 'result']"><fo:block xsl:use-attribute-sets="result"><xsl:apply-templates /></fo:block>
</xsl:template>

<xsl:template match="div[@class = 'comment']"><fo:block xsl:use-attribute-sets="div.comment"><xsl:apply-templates /></fo:block>
</xsl:template>

<xsl:template match="a">
	<xsl:apply-templates />
	<xsl:if test="count(child::node()) = 0">
	<fo:inline >
		<xsl:text>(</xsl:text>
			<xsl:value-of select="@href" />
		<xsl:text>)</xsl:text>
	</fo:inline>
	</xsl:if>
</xsl:template>

  <xsl:template match="cite"><xsl:apply-templates /></xsl:template>

  <xsl:template match="comment"><!-- no output-->
</xsl:template>
  <xsl:template match="note"><fo:footnote><fo:inline baseline-shift="super" font-size="75%"><xsl:number count="//note"  level="any"  format="(1)" /></fo:inline><fo:footnote-body><fo:block xsl:use-attribute-sets="note"><fo:inline baseline-shift="super" font-size="75%">       <xsl:number count="//note" level="any" format="(1)"/></fo:inline><xsl:apply-templates /></fo:block>
</fo:footnote-body>
</fo:footnote>
</xsl:template>

  <xsl:template match="span"><fo:inline ><xsl:apply-templates /></fo:inline>
</xsl:template>

  <xsl:template match="b"><fo:inline font-weight="bold"><xsl:apply-templates /></fo:inline>
</xsl:template>

  <xsl:template match="i"><fo:inline font-style="italic"><xsl:apply-templates /></fo:inline>
</xsl:template>

  <xsl:template match="dfn"><xsl:apply-templates /></xsl:template>

  <xsl:template match="tt"><xsl:apply-templates /></xsl:template>

  <xsl:template match="em"><fo:inline xsl:use-attribute-sets="em"><xsl:apply-templates /></fo:inline>
</xsl:template>

  <xsl:template match="abbr"><xsl:apply-templates /></xsl:template>

  <xsl:template match="acronym"><xsl:apply-templates /></xsl:template>

  <xsl:template match="code"><fo:inline font-weight="bold"><xsl:apply-templates /></fo:inline>
</xsl:template>

  <xsl:template match="blockquote"><fo:block xsl:use-attribute-sets="blockquote"><xsl:apply-templates /></fo:block>
</xsl:template>

  <xsl:template match="q"><fo:inline xsl:use-attribute-sets="q"><xsl:apply-templates /></fo:inline>
</xsl:template></xsl:stylesheet >
 