<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to DocBook Stylesheet
Module: Main control.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:db="http://docbook.org/ns/docbook"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 exclude-result-prefixes="ahf ahp">
    
    <!-- 
     function:	document template
     param:	    none
     return:	chapter
     note:	    none
     -->
    <xsl:template match="ahp:document">
        <xsl:variable name="document" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:chapter>
            <db:title></db:title>
            <xsl:apply-templates/>
        </db:chapter>
    </xsl:template>
    
    <!-- 
     function:	page template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:page[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetPage(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:page">
        <xsl:variable name="page" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <xsl:apply-templates select="* except (ahp:footer | ahp:footer)"/>
    </xsl:template>
    
    <!-- 
     function:	section template
     param:	    none
     return:	fo:block-container
     note:	    none
     -->
    <xsl:template match="ahp:section[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetSection(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:section">
        <xsl:variable name="section" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <xsl:comment>@ahp:section-column-count=<xsl:value-of select="$section/@ahp:section-column-count"/></xsl:comment>
        <db:section>
            <xsl:apply-templates select="* except ahp:section-column"/>
        </db:section>
    </xsl:template>

    <!-- 
     function:	frame template
     param:	    none
     return:	imageobject or other
     note:	    none
     -->
    <xsl:template match="ahp:frame[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetFrame(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ahp:frame">
        <xsl:variable name="frame" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <xsl:comment>[ahp:frame] start</xsl:comment>
            <xsl:choose>
                <xsl:when test="string($frame/@ahp:frame-type) = ('image','svg')">
                    <xsl:variable name="href" as="xs:string" select="ahf:getExtrenalGraphicPath(string($frame/@ahp:file-id))"/>
                    <db:mediaobject>
                        <db:imageobject>
                            <db:imagedata fileref="{$href}">
                                <xsl:attribute name="width" select="ahf:getLength($frame/@ahp:l,$frame/@ahp:r)"/>
                                <xsl:attribute name="depth" select="ahf:getLength($frame/@ahp:t,$frame/@ahp:b)"/>
                            </db:imagedata>
                        </db:imageobject>
                    </db:mediaobject>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        <xsl:comment>[ahp:frame] end</xsl:comment>
    </xsl:template>
 
    <!-- 
     function:	p template
     param:	    none
     return:	para
     note:	    none
     -->
    <xsl:template match="ahp:p[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetP(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ahp:p">
        <xsl:variable name="p" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:para>
            <xsl:apply-templates/>
        </db:para>
    </xsl:template>

    <!-- 
     function:	line template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:line[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetLine(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ahp:line">
        <xsl:variable name="line" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- 
     function:	run template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:run[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetRun(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:run">
        <xsl:variable name="run" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- 
     function:	table template
     param:	    none
     return:	table
     note:	    none
     -->
    <xsl:template match="ahp:table">
        <xsl:variable name="table" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:table>
            <!--xsl:copy-of select="ahf:getStyle($table/@ahp:s-id)"/-->
            <xsl:attribute name="width" select="ahf:getLength($table/@ahp:l,$table/@ahp:r)"/>
            <db:caption/>
            <xsl:apply-templates select="ahp:table-column"/>
            <xsl:apply-templates select="ahp:row"/>
        </db:table>
    </xsl:template>
    
    <!-- 
     function:	table-column template
     param:	    none
     return:	col
     note:	    none
     -->
    <xsl:template match="ahp:table-column">
        <xsl:variable name="tableColumn" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:col>
            <!--xsl:copy-of select="ahf:getStyle($table/@ahp:s-id)"/-->
            <xsl:attribute name="width" select="ahf:getLength($tableColumn/@ahp:width)"/>
        </db:col>
    </xsl:template>
    
    <!-- 
     function:	row template
     param:	    none
     return:	tr
     note:	
     -->
    <xsl:template match="ahp:row">
        <xsl:variable name="row" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$row/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:tr>
            <xsl:apply-templates/>
        </db:tr>
    </xsl:template>
    
    <!-- 
     function:	cell template
     param:	none
     return:	fo:block-container
     note:	
     -->
    <xsl:template match="ahp:cell">
        <xsl:variable name="cell" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$cell/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <db:td>
            <!--xsl:copy-of select="ahf:getStyle($cell/@ahp:s-id)"/-->
            <xsl:apply-templates/>
        </db:td>
    </xsl:template>

    <!-- 
     function:	get writing-mode
     param:	prmElem
     return:	attribute()
     note:	none
     -->
    <xsl:function name="ahf:getWritingModeAttr" as="attribute()?">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="writingMode" as="xs:string" select="string($prmElem/@ahp:writing-mode)"/>
        <xsl:choose>
            <xsl:when test="$writingMode eq 'vertical'">
                <xsl:attribute name="writing-mode" select="'tb-lr'"/>
            </xsl:when>
            <xsl:when test="$writingMode eq 'horizontal'">
                <xsl:attribute name="writing-mode" select="'lr-tb'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get z-orfder
     param:	prmElem
     return:	attribute()?
     note:	none
     -->
    <xsl:function name="ahf:getZOrder" as="attribute()?">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="zOrder" as="xs:string" select="string($prmElem/@ahp:z-order)"/>
        <xsl:choose>
            <xsl:when test="string($zOrder)">
                <xsl:attribute name="z-order" select="$zOrder"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get column-count
     param:	prmElem
     return:	attribute()
     note:	none
     -->
    <xsl:function name="ahf:getColumCountAttr" as="attribute()">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:attribute name="column-count" select="string($prmElem/@ahp:section-column-count)"/>
    </xsl:function>

    <!-- 
     function:	get external graphic path
     param:	prmElem
     return:	xs:string
     note:	none
     -->
    <xsl:function name="ahf:getExtrenalGraphicPath" as="xs:string">
        <xsl:param name="prmId" as="xs:string"/>
        <!--xsl:variable name="content" as="element()?" select="key('keyContentById',$prmId,$glContents)[1]"/-->
        <xsl:variable name="href" as="attribute()?" select="$glContents/ahp:content[string(@ahp:id) eq $prmId]/@ahp:href"/>
        <xsl:choose>
            <xsl:when test="exists($href)">
                <xsl:sequence select="string($href)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="''"/>
                <xsl:call-template name="errorExit">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes003,('%id','%file'),($prmId,string(document-uri($glContents))))"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
