<?xml version="1.0" encoding="UTF-8"?>
<!--
**************************************************************
AHPDFXML to xx Stylesheet 
Filter utility Templates
**************************************************************
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL : http://www.antennahouse.co.jp/
**************************************************************
-->

<xsl:stylesheet version="2.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="xs ahf ahp" >

    <!-- 
	     ahf:isTargetPage
	     機能： 入力XMLをフィルタリングする場合、変換対象ページか否かをxs:booleanで返します。
	     パラメータ：ahp:page
	     備考： フィルターパラメータがあればそのページでtrue()を返します。
    -->
    <xsl:function name="ahf:isTargetPage" as="xs:boolean">
        <xsl:param name="prmPage" as="element(ahp:page)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:variable name="pageNo" as="xs:integer" select="count($prmPage/preceding-sibling::ahp:page) + 1"/>
                <xsl:sequence select="$pageNo eq $glFilterPage"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
	     ahf:isInRange
	     機能： 入力XMLをフィルタリングする場合、$prmElemが対象範囲（top,bottom,left,right)の中に包含されるかを返します。
	     パラメータ：ahp:*
	     備考： フィルタリングするtop,bottom,left,rightの範囲内ならtrue()を返します。
	            AHPDFXMLのtop,bottom,left,rightの単位はptの前提です。
    -->
    <xsl:function name="ahf:isInsideFilterRange" as="xs:boolean">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:variable name="top" as="xs:double" select="xs:double($prmElem/@ahp:t)"/>
                <xsl:variable name="bottom" as="xs:double" select="xs:double($prmElem/@ahp:b)"/>
                <xsl:variable name="left" as="xs:double" select="xs:double($prmElem/@ahp:l)"/>
                <xsl:variable name="right" as="xs:double" select="xs:double($prmElem/@ahp:r)"/>
                <xsl:sequence select="($top ge $glFilterTop) and
                                      ($bottom le $glFilterBottom) and
                                      ($left ge $glFilterLeft) and
                                      ($right le $glFilterRight)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
	     ahf:isTargetSection
	     機能： 入力XMLをフィルタリングする場合、$prmSectionが対象範囲（top,bottom,left,right)のrun,table,frame(image,svg)を含むかを返します。
	     パラメータ：ahp:section
	     備考： 
    -->
    <xsl:function name="ahf:isTargetSection" as="xs:boolean">
        <xsl:param name="prmSection" as="element(ahp:section)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:variable name="isTarget" as="xs:boolean*">
                    <xsl:for-each select="$prmSection/ahp:frame">
                        <xsl:variable name="frame" as="element()" select="."/>
                        <xsl:sequence select="ahf:isTargetFrame($frame)"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:sequence select="exists($isTarget[. eq true()])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
	     ahf:isTargetFrame
	     機能： 入力XMLをフィルタリングする場合、$prmFrameが対象範囲（top,bottom,left,right)のrun,table,frame(image,svg)を含むかを返します。
	     パラメータ：ahp:frame
	     備考： 
    -->
    <xsl:function name="ahf:isTargetFrame" as="xs:boolean">
        <xsl:param name="prmFrame" as="element(ahp:frame)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:choose>
                    <xsl:when test="string($prmFrame/@ahp:frame-type) = ('table','image','svg','text-box','text-box-table')">
                        <xsl:sequence select="ahf:isInsideFilterRange($prmFrame)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="isTarget" as="xs:boolean*">
                            <xsl:for-each select="$prmFrame/ahp:p">
                                <xsl:variable name="p" as="element()" select="."/>
                                <xsl:sequence select="ahf:isTargetP($p)"/>
                            </xsl:for-each>
                        </xsl:variable>
                        <xsl:sequence select="exists($isTarget[. eq true()])"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
	     ahf:isTargetP
	     機能： 入力XMLをフィルタリングする場合、$prmPが対象範囲（top,bottom,left,right)のrunを含むかを返します。
	     パラメータ：ahp:frame
	     備考： 
    -->
    <xsl:function name="ahf:isTargetP" as="xs:boolean">
        <xsl:param name="prmP" as="element(ahp:p)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:variable name="isTarget" as="xs:boolean*">
                    <xsl:for-each select="$prmP/ahp:line">
                        <xsl:variable name="line" as="element()" select="."/>
                        <xsl:sequence select="ahf:isTargetLine($line)"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:sequence select="exists($isTarget[. eq true()])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
	     ahf:isTargetLine
	     機能： 入力XMLをフィルタリングする場合、$prmLineが対象範囲（top,bottom,left,right)のrunを含むかを返します。
	     パラメータ：ahp:line
	     備考： 
    -->
    <xsl:function name="ahf:isTargetLine" as="xs:boolean">
        <xsl:param name="prmLine" as="element(ahp:line)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:variable name="isTarget" as="xs:boolean*">
                    <xsl:for-each select="$prmLine/ahp:run">
                        <xsl:variable name="run" as="element()" select="."/>
                        <xsl:sequence select="ahf:isTargetRun($run)"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:sequence select="exists($isTarget[. eq true()])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
	     ahf:isTargetRun
	     機能： 入力XMLをフィルタリングする場合、$prmRunが対象範囲（top,bottom,left,right)に含まれるかを返します。
	     パラメータ：ahp:run
	     備考： 
    -->
    <xsl:function name="ahf:isTargetRun" as="xs:boolean">
        <xsl:param name="prmRun" as="element(ahp:run)"/>
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="ahf:isInsideFilterRange($prmRun)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>