<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to XSL-FO Stylesheet
Module: Main control.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:fo="http://www.w3.org/1999/XSL/Format" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 exclude-result-prefixes="ahf">
    
    <!-- 
     function:	document template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:document">
        <xsl:apply-templates select="ahp:page"/>
    </xsl:template>
    
    <!-- 
     function:	page template
     param:	none
     return:	fo:page-sequence
     note:	none
     -->
    <xsl:template match="ahp:page[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetPage(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="ahp:page">
        <xsl:variable name="page" as="element()" select="."/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:page-sequence>
            <xsl:attribute name="master-reference" select="ahf:getSpmName($page)"/>
            <fo:flow flow-name="xsl-region-body">
                <xsl:apply-templates/>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
    
    <!-- 
     function:	section template
     param:	none
     return:	fo:block-container
     note:	none
     -->
    <xsl:template match="ahp:section[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetSection(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:section">
        <xsl:variable name="section" as="element()" select="."/>
        <xsl:variable name="page" as="element()" select="$section/parent::ahp:page"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container>
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getAbsPosFromAttr($section/@ahp:t)"/>
            <!--xsl:attribute name="bottom" select="ahf:getAbsPosFromAttr($section/@ahp:b)"/-->
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($page/@ahp:height,$section/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getAbsPosFromAttr($section/@ahp:l)"/>
            <!--xsl:attribute name="right" select="ahf:getAbsPosFromAttr($section/@ahp:r)"/-->
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($page/@ahp:width,$section/@ahp:r)"/>
            <xsl:copy-of select="ahf:getWritingModeAttr($section)"/>
            <!--xsl:copy-of select="ahf:getColumCountAttr($section)"/-->
            <xsl:copy-of select="ahf:getStyle($section/@ahp:s-id)"/>
            <xsl:apply-templates select="* except ahp:section-column"/>
        </fo:block-container>
    </xsl:template>

    <!-- 
     function:	frame template
     param:	none
     return:	fo:block-container
     note:	none
     -->
    <xsl:template match="ahp:frame[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetFrame(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:frame">
        <xsl:variable name="frame" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$frame/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container>
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$frame/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$frame/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$frame/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$frame/@ahp:r)"/>
            <xsl:copy-of select="ahf:getWritingModeAttr($frame)"/>
            <xsl:copy-of select="ahf:getZOrder($frame)"/>
            <!--xsl:copy-of select="ahf:getColumCountAttr($section)"/-->
            <xsl:copy-of select="ahf:getStyle($frame/@ahp:s-id)"/>
            <xsl:choose>
                <xsl:when test="string($frame/@ahp:frame-type) = ('image','svg')">
                    <!--xsl:message select="'ahp:file-id=',string($frame/@ahp:file-id)"/-->
                    <xsl:variable name="href" as="xs:string" select="ahf:getExtrenalGraphicPath(string($frame/@ahp:file-id))"/>
                    <fo:block>
                        <fo:external-graphic src="{$href}">
                            <xsl:attribute name="content-width" select="ahf:getLength($frame/@ahp:l,$frame/@ahp:r)"/>
                            <xsl:attribute name="content-height" select="ahf:getLength($frame/@ahp:t,$frame/@ahp:b)"/>
                        </fo:external-graphic>
                    </fo:block>    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </fo:block-container>
    </xsl:template>
 
    <!-- 
     function:	p template
     param:	none
     return:	fo:block-container
     note:	none
     -->
    <xsl:template match="ahp:p[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetP(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:p">
        <xsl:variable name="p" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$p/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container>
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$p/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$p/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$p/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$p/@ahp:r)"/>
            <xsl:copy-of select="ahf:getStyle($p/@ahp:s-id)"/>
            <xsl:apply-templates/>
        </fo:block-container>
    </xsl:template>

    <!-- 
     function:	line template
     param:	none
     return:	fo:block-container
     note:	none
     -->
    <xsl:template match="ahp:line[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetLine(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:line">
        <xsl:variable name="line" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$line/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container>
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$line/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$line/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$line/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$line/@ahp:r)"/>
            <xsl:apply-templates/>
        </fo:block-container>
    </xsl:template>

    <!-- 
     function:	run template
     param:	none
     return:	fo:block-container/fo:block
     note:	none
     -->
    <xsl:template match="ahp:run[$glHasValidFilterParam]" priority="2">
        <xsl:if test="ahf:isTargetRun(.)">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ahp:run">
        <xsl:variable name="run" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$run/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container>
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$run/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$run/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$run/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$run/@ahp:r)"/>
            <xsl:copy-of select="ahf:getStyle($run/@ahp:s-id)"/>
            <fo:block>
                <xsl:apply-templates/>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <!-- 
     function:	table template
     param:	none
     return:	fo:block-container
     note:	
     -->
    <xsl:template match="ahp:table">
        <xsl:variable name="table" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$table/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container  border="2pt solid blue">
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$table/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$table/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$table/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$table/@ahp:r)"/>
            <xsl:copy-of select="ahf:getStyle($table/@ahp:s-id)"/>
            <xsl:apply-templates select="* except ahp:table-column"/>
        </fo:block-container>
    </xsl:template>
    
    <!-- 
     function:	row template
     param:	none
     return:	fo:block-container
     note:	
     -->
    <xsl:template match="ahp:row">
        <xsl:variable name="row" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$row/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container  border="1pt solid red">
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$row/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$row/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$row/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$row/@ahp:r)"/>
            <xsl:copy-of select="ahf:getStyle($row/@ahp:s-id)"/>
            <xsl:apply-templates/>
        </fo:block-container>
    </xsl:template>
    
    <!-- 
     function:	cell template
     param:	none
     return:	fo:block-container
     note:	
     -->
    <xsl:template match="ahp:cell">
        <xsl:variable name="cell" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$cell/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <fo:block-container  border="1pt solid yellow">
            <xsl:attribute name="absolute-position" select="'absolute'"/>
            <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$cell/@ahp:t)"/>
            <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$cell/@ahp:b)"/>
            <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$cell/@ahp:l)"/>
            <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$cell/@ahp:r)"/>
            <xsl:copy-of select="ahf:getStyle($cell/@ahp:s-id)"/>
            <xsl:apply-templates/>
        </fo:block-container>
    </xsl:template>

    <!-- 
     function:	get writing-mode
     param:	prmElem
     return:	attribute()
     note:	none
     -->
    <xsl:function name="ahf:getWritingModeAttr" as="attribute()?">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="writingMode" as="xs:string" select="string($prmElem/@ahp:writing-mode)"/>
        <xsl:choose>
            <xsl:when test="$writingMode eq 'vertical'">
                <xsl:attribute name="writing-mode" select="'tb-rl'"/>
            </xsl:when>
            <xsl:when test="$writingMode eq 'horizontal'">
                <xsl:attribute name="writing-mode" select="'lr-tb'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get z-order
     param:	prmElem
     return:	attribute()?
     note:	none
     -->
    <xsl:function name="ahf:getZOrder" as="attribute()?">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="zOrder" as="xs:string" select="string($prmElem/@ahp:z-order)"/>
        <xsl:choose>
            <xsl:when test="string($zOrder)">
                <xsl:attribute name="z-index" select="$zOrder"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get column-count
     param:	prmElem
     return:	attribute()
     note:	none
     -->
    <xsl:function name="ahf:getColumCountAttr" as="attribute()">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:attribute name="column-count" select="string($prmElem/@ahp:section-column-count)"/>
    </xsl:function>

    <!-- 
     function:	get external graphic path
     param:	prmElem
     return:	xs:string
     note:	none
     -->
    <xsl:function name="ahf:getExtrenalGraphicPath" as="xs:string">
        <xsl:param name="prmId" as="xs:string"/>
        <!--xsl:variable name="content" as="element()?" select="key('keyContentById',$prmId,$glContents)[1]"/-->
        <xsl:variable name="href" as="attribute()?" select="$glContents/ahp:content[string(@ahp:id) eq $prmId]/@ahp:href"/>
        <xsl:choose>
            <xsl:when test="exists($href)">
                <xsl:sequence select="string($href)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="''"/>
                <xsl:call-template name="errorExit">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes003,('%id','%file'),($prmId,string(document-uri($glContents))))"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
