<?xml version="1.0" encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to XSL-FO Stylesheet 
Module: Stylesheet global variables.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:fo="http://www.w3.org/1999/XSL/Format" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
>
    <!-- *************************************** 
            Constants
         ***************************************-->
    <!-- namespace -->
    <xsl:variable name="ahpNs" as="xs:string" select="'http://www.antennahouse.com/names/PDF/AHPDFXML'"/>

    <!-- External Parameter yes/no value -->
    <xsl:variable name="cYes" select="'yes'" as="xs:string"/>
    <xsl:variable name="cNo" select="'no'" as="xs:string"/>
    
    <!-- Inner flag/attribute value: true/false -->
    <xsl:variable name="cTrue" select="'true'" as="xs:string"/>
    <xsl:variable name="cFalse" select="'false'" as="xs:string"/>
    
    <xsl:variable name="NaN" select="'NaN'" as="xs:string"/>
    <xsl:variable name="cCR" select="'&#x0D;'" as="xs:string"/>
    <xsl:variable name="cLF" select="'&#x0A;'" as="xs:string"/>
    <xsl:variable name="cCRLF" select="'&#x0D;&#x0A;'" as="xs:string"/>
    
    <!-- units -->
    <xsl:variable name="cUnitPc" select="'pc'" as="xs:string"/>
    <xsl:variable name="cUnitPt" select="'pt'" as="xs:string"/>
    <xsl:variable name="cUnitPx" select="'px'" as="xs:string"/>
    <xsl:variable name="cUnitIn" select="'in'" as="xs:string"/>
    <xsl:variable name="cUnitCm" select="'cm'" as="xs:string"/>
    <xsl:variable name="cUnitMm" select="'mm'" as="xs:string"/>
    <xsl:variable name="cUnitEm" select="'em'" as="xs:string"/>

    <xsl:variable name="ahpLengthUnit" as="xs:string" select="$cUnitPt"/>
    <xsl:variable name="ahpPositionUnit" as="xs:string" select="$cUnitPt"/>
    
    <!--  Variables depending on input catalog file
     -->
    <!-- Top level element -->
    <xsl:variable name="glContents" select="/*[1]" as="element()"/>
    
    <!--document-->
    <xsl:variable name="glDocumentPath" as="xs:string">
        <xsl:variable name="contentDocument" as="element()?" select="$glContents/ahp:content[string(@ahp:file-type) eq 'DOCUMENT']"/>
        <xsl:choose>
            <xsl:when test="exists($contentDocument)">
                <xsl:sequence select="string($contentDocument/@ahp:href)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="''"/>
                <xsl:call-template name="errorExit">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes001,('%file-type','%file'),('DOCUMENT',string(document-uri($glContents))))"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glDocumentDoc" as="document-node()">
        <xsl:sequence select="document($glDocumentPath,$glContents)"/>
    </xsl:variable>
    
    <!--style-->
    <xsl:variable name="glStylePath" as="xs:string">
        <xsl:variable name="contentStyle" as="element()?" select="$glContents/ahp:content[string(@ahp:file-type) eq 'STYLE']"/>
        <xsl:choose>
            <xsl:when test="exists($contentStyle)">
                <xsl:sequence select="string($contentStyle/@ahp:href)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="''"/>
                <xsl:call-template name="errorExit">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes001,('%file-type','%file'),('STYLE',string(document-uri($glContents))))"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glStyleRoot" as="element()?">
        <xsl:sequence select="document($glStylePath,$glContents)/ahp:styles"/>
    </xsl:variable>
    
    <!--展開されたスタイル
        <ahp:style-def ahp:name="~" font-family="MS-MIncho" ...>
        ...
        のようになるはず。
      -->
    <xsl:variable name="glStyleDef" as="document-node()">
        <xsl:document>
            <xsl:apply-templates select="$glStyleRoot/ahp:style" mode="MODE_GEN_STYLE_DEF"/>
        </xsl:document>
    </xsl:variable>
    
    <!-- Keys -->
    <!-- Content by id -->
    <!--何故かうまく動いてくれない-->
    <xsl:key name="keyContentById" match="//*[@ahp:id]" use="@ahp:id"/>

</xsl:stylesheet>
