<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to XSL-FO Stylesheet
Module: Generate fo:layout-master-set.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:fo="http://www.w3.org/1999/XSL/Format" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 exclude-result-prefixes="ahp">

    <!-- 
     function:	generate layout master set
     param:		none
     return:	fo:layout-master-set
     note:		none
    -->
    
    <xsl:template name="genLayoutMasterSet">
    	<fo:layout-master-set>
    		<xsl:call-template name="genSimplePageMaster"/>
    		<!--xsl:call-template name="genPageSequenceMaster"/-->
    	</fo:layout-master-set>
    </xsl:template>
    
    <!-- 
     function:	generate simple-page master
     param:		none
     return:	fo:simple-page-master
     note:		none
    -->
    <xsl:template name="genSimplePageMaster">
        <xsl:for-each select="$glDocumentDoc/ahp:document/ahp:page">
            <xsl:variable name="page" as="element()" select="."/>
            <fo:simple-page-master master-name="{ahf:getSpmName($page)}">
                <xsl:attribute name="page-width"   select="ahf:getLengthFromAttr($page/@ahp:width)"/>
                <xsl:attribute name="page-height"   select="ahf:getLengthFromAttr($page/@ahp:height)"/>
                <fo:region-body xsl:use-attribute-sets="atsCommonRegionBody"/>
            </fo:simple-page-master>
        </xsl:for-each>
    </xsl:template>
    
    <!-- 
     function:	generate simple-page master name
     param:		page
     return:	xs:string
     note:		none
    -->
    <xsl:function name="ahf:getSpmName" as="xs:string">
        <xsl:param name="prmPage" as="element()"/>
        <xsl:sequence select="concat('spm_',generate-id($prmPage))"/>
    </xsl:function>
    
    <!--xsl:template name="genPsm">
        <fo:page-sequence-master master-name="pmsPageSeqFrontmatter">
        	<fo:repeatable-page-master-alternatives>
        		<fo:conditional-page-master-reference master-reference="pmsFrontmatterLeft" 
                                                      odd-or-even="even"  
                                                      page-position="any"
                                                      blank-or-not-blank="not-blank"/>
        		<fo:conditional-page-master-reference master-reference="pmsFrontmatterRight" 
                                                      odd-or-even="odd"  
                                                      page-position="any"
                                                      blank-or-not-blank="not-blank"/>
        		<fo:conditional-page-master-reference master-reference="pmsFrontmatterBlank" 
                                                      odd-or-even="any"  
                                                      page-position="any"
                                                      blank-or-not-blank="blank"/>
        	</fo:repeatable-page-master-alternatives>
        </fo:page-sequence-master>
    </xsl:template-->

</xsl:stylesheet>
