<?xml version="1.0" encoding="UTF-8"?>
<!--
****************************************************************
AHPDFXML to XSL-FO Stylesheet
Module: Parameter definition.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="ahf" 
    >
    
    <xsl:param name="PRM_FILTER" as="xs:string" required="no" select="''"/>
    <xsl:variable name="pFilter" select="normalize-space($PRM_FILTER)"/>
    <xsl:variable name="glHasFilter" select="boolean(string($pFilter))"/>
    
    <xsl:variable name="filterParam" as="xs:string*">
        <xsl:for-each select="tokenize($pFilter,';')">
            <xsl:variable name="filterParam" as="xs:string" select="."/>
            <xsl:sequence select="$filterParam"/>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="glHasValidFilterParam" as="xs:boolean">
        <xsl:choose>
            <xsl:when test="count($filterParam) eq 5">
                <xsl:variable name="hasValidFilterParam" as="xs:boolean+">
                    <xsl:sequence select="$filterParam[1] castable as xs:integer"/>
                    <xsl:for-each select="$filterParam[position() gt 1]">
                        <xsl:sequence select="ahf:isValidUnitValue(.)"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:sequence select="empty($hasValidFilterParam[. eq false()])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="false()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glFilterPage" as="xs:integer">
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="xs:integer($filterParam[1])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glFilterLeft" as="xs:double">
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="ahf:covertToPt($filterParam[2])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glFilterRight" as="xs:double">
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="ahf:covertToPt($filterParam[3])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="glFilterTop" as="xs:double">
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="ahf:covertToPt($filterParam[4])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="glFilterBottom" as="xs:double">
        <xsl:choose>
            <xsl:when test="$glHasValidFilterParam">
                <xsl:sequence select="ahf:covertToPt($filterParam[5])"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

</xsl:stylesheet>
