<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to XSL-FO Stylesheet
Module: Style expand control.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="ahf">
    
    <!-- 
     function:	style element generation template
     param:	    none
     return:	style element
     note:	    none
     -->
    <xsl:template match="ahp:style" mode="MODE_GEN_STYLE_DEF">
        <ahp:style-def>
            <xsl:attribute name="ahp:name" select="string(@ahp:name)"/>
            <xsl:apply-templates select="."/>
        </ahp:style-def>
    </xsl:template>
    
    <!-- 
     function:	get style from style name
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:function name="ahf:getStyleByName" as="attribute()*">
        <xsl:param name="prmStyleName" as="xs:string"/>
        <xsl:sequence select="$glStyleDef/ahp:style-def[string(@ahp:name) eq $prmStyleName]/@*[namespace-uri() ne $ahpNs]"/>
    </xsl:function>

    <xsl:function name="ahf:getStyle" as="attribute()*">
        <xsl:param name="prmAttr" as="attribute()?"/>
        <xsl:choose>
            <xsl:when test="exists($prmAttr)">
                <xsl:sequence select="ahf:getStyleByName(string($prmAttr))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	style template
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:template match="ahp:style[string(@parent)]" priority="2">
        <xsl:variable name="style" as="element()" select="."/>
        <xsl:variable name="parentStyle" as="xs:string" select="string($style/@parent)"/>
        <xsl:apply-templates select="$glStyleRoot/ahp:style[string(@name) eq $parentStyle]"/>
        <xsl:next-match/>
    </xsl:template>

    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'page']">
        <xsl:variable name="style" as="element()" select="."/>
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'section']">
        <xsl:variable name="style" as="element()" select="."/>
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'frame']">
        <xsl:variable name="style" as="element()" select="."/>
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'p']">
        <xsl:variable name="style" as="element()" select="."/>
        <!-- XSL-FOにはｐはfo:block-containerで出すのでインデントは反映させない。
             反映させるとかえってレイアウトが崩れます。
          -->
        <!--xsl:if test="$style/@ahp:indent-first">
            <xsl:attribute name="text-indent" select="ahf:getLengthFromAttr($style/@ahp:indent-first)"/>
        </xsl:if>
        <xsl:if test="$style/@ahp:indent-start">
            <xsl:attribute name="start-indent" select="ahf:getLengthFromAttr($style/@ahp:indent-start)"/>
        </xsl:if>
        <xsl:if test="$style/@ahp:indent-end">
            <xsl:attribute name="end-indent" select="ahf:getLengthFromAttr($style/@ahp:indent-end)"/>
        </xsl:if-->
        <xsl:if test="$style/@ahp:height">
            <!--heightは正の値しか出てこない-->
            <xsl:attribute name="line-height" select="ahf:getLengthFromAttr($style/@ahp:height)"/>
        </xsl:if>
        <xsl:if test="$style/@space-before">
            <xsl:attribute name="space-before" select="ahf:getLengthFromAttr($style/@ahp:space-before)"/>
        </xsl:if>
        <xsl:if test="$style/@space-after">
            <xsl:attribute name="space-after" select="ahf:getLengthFromAttr($style/@ahp:space-after)"/>
        </xsl:if>
        <xsl:if test="string($style/@align)">
            <xsl:variable name="align" select="string($style/@align)"/>
            <xsl:choose>
                <xsl:when test="$align = ('start','end','center','justify')">
                    <xsl:attribute name="text-align" select="$align"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:sequence select="()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>

    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'run']">
        <xsl:variable name="style" as="element()" select="."/>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>

    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'table']">
        <xsl:variable name="style" as="element()" select="."/>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>
    
    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'row']">
        <xsl:variable name="style" as="element()" select="."/>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>
    
    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'cell']">
        <xsl:variable name="style" as="element()" select="."/>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>

    <xsl:template match="ahp:style[string(@ahp:style-type) eq 'page-no']">
        <xsl:variable name="style" as="element()" select="."/>
        <!--網掛けはいまのところ実装できない-->
        <xsl:apply-templates select="* except (ahp:mesh-color | ahp:mesh-back-color)"/>
    </xsl:template>

    <!-- 
     function:	border template
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:template match="ahp:border-t">
        <xsl:copy-of select="ahf:getBorderType(.,'border-before')"/>
        <xsl:copy-of select="ahf:getBorderWidth(.,'border-before')"/>
        <xsl:apply-templates select="ahp:color">
            <xsl:with-param name="prmBorderPos" select="'border-before'"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="ahp:border-b">
        <xsl:copy-of select="ahf:getBorderType(.,'border-after')"/>
        <xsl:copy-of select="ahf:getBorderWidth(.,'border-after')"/>
        <xsl:apply-templates select="ahp:color">
            <xsl:with-param name="prmBorderPos" select="'border-after'"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="ahp:border-l">
        <xsl:copy-of select="ahf:getBorderType(.,'border-start')"/>
        <xsl:copy-of select="ahf:getBorderWidth(.,'border-start')"/>
        <xsl:apply-templates select="ahp:color">
            <xsl:with-param name="prmBorderPos" select="'border-start'"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="ahp:border-r">
        <xsl:copy-of select="ahf:getBorderType(.,'border-end')"/>
        <xsl:copy-of select="ahf:getBorderWidth(.,'border-end')"/>
        <xsl:apply-templates select="ahp:color">
            <xsl:with-param name="prmBorderPos" select="'border-end'"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- 
     function:	color template
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:template match="ahp:color">
        <xsl:param name="prmBorderPos" as="xs:string" required="no" select="''"/>
        <xsl:variable name="color" as="element()" select="."/>
        <xsl:variable name="rgbVal" as="xs:string" select="string($color/@ahp:rgb)"/>
        <xsl:choose>
            <xsl:when test="string($prmBorderPos)">
                <xsl:attribute name="{concat($prmBorderPos,'-color')}" select="$rgbVal"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="color" select="$rgbVal"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- 
     function:	color template
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:template match="ahp:back-color">
        <xsl:param name="prmBoderPos" as="xs:string" required="no" select="''"/>
        <xsl:variable name="color" as="element()" select="."/>
        <xsl:variable name="rgbVal" as="xs:string" select="concat('#',string($color/@ahp:rgb))"/>
        <xsl:attribute name="background-color" select="$rgbVal"/>
    </xsl:template>

    <!-- 
     function:	font template
     param:	    none
     return:	attribute()*
     note:	    none
     -->
    <xsl:template match="ahp:font">
        <xsl:param name="prmBoderPos" as="xs:string" required="no" select="''"/>
        <xsl:variable name="font" as="element()" select="."/>
        <xsl:if test="$font/@ahp:name">
            <xsl:attribute name="font-family" select="string($font/@ahp:name)"/>
        </xsl:if>
        <!--pitchは冗長な情報-->
        <xsl:if test="$font/@ahp:size">
            <xsl:attribute name="font-size" select="ahf:getLengthFromAttr($font/@ahp:size)"/>
        </xsl:if>
        <xsl:if test="$font/@ahp:horizontal-percent">
            <xsl:attribute name="font-stretch" select="concat(string($font/@ahp:horizontal-percent),'%')"/>
        </xsl:if>
        <!--vertical-percentは実装できない-->
        <xsl:if test="$font/@ahp:space-character">
            <xsl:attribute name="letter-spacing" select="ahf:getLengthFromAttr($font/@ahp:space-character)"/>
        </xsl:if>
        <xsl:if test="string($font/@ahp:bold) eq $cTrue">
            <xsl:attribute name="font-weight" select="'bold'"/>
        </xsl:if>
        <xsl:if test="string($font/@ahp:italic) eq $cTrue">
            <xsl:attribute name="font-style" select="'italic'"/>
        </xsl:if>
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <!-- 
     function:	add-space template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:add-space"/>
        
    <!-- 
     function:	add-space template
     param:	    none
     return:	attribute()?
     note:	    none
     -->
    <xsl:template match="ahp:stroke">
        <xsl:variable name="stroke" as="element()" select="."/>
        <xsl:if test="string($stroke) eq $cTrue">
            <xsl:attribute name="text-decoration" select="'line-through'"/>
        </xsl:if>
    </xsl:template>
    
    <!-- 
     function:	list-text-result template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:list-text-result"/>

    <!-- 
     function:	vertical-align template
     param:	    none
     return:	attribute()?
     note:	    none
     -->
    <xsl:template match="ahp:vertical-align">
        <xsl:variable name="verticalAlign" as="xs:string" select="string(.)"/>
        
        <xsl:choose>
            <xsl:when test="$verticalAlign eq 't'">
                <xsl:attribute name="display-align" select="'before'"/>
            </xsl:when>
            <xsl:when test="$verticalAlign eq 'center'">
                <xsl:attribute name="display-align" select="'center'"/>
            </xsl:when>
            <xsl:when test="$verticalAlign eq 'b'">
                <xsl:attribute name="display-align" select="'after'"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- 
     function:	data-type template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:data-type"/>
    
    <!-- 
     function:	no-format template
     param:	    none
     return:	none
     note:	    none
     -->
    <xsl:template match="ahp:no-format"/>

    <!-- 
     function:	get border type
     param:	    prmBorder, prmBorderPos
     return:	attribute()?
     note:	    none
     -->
    <xsl:function name="ahf:getBorderType" as="attribute()?">
        <xsl:param name="prmBorder" as="element()"/>
        <xsl:param name="prmBoderPos" as="xs:string"/>
        <xsl:variable name="borderTypeAttr" as="attribute()?" select="$prmBorder/@ahp:border-type"/>
        <xsl:variable name="borderTypeName" as="xs:string" select="concat($prmBoderPos,'-style')"/>
        <xsl:choose>
            <xsl:when test="exists($borderTypeAttr)">
                <xsl:variable name="borderType" as="xs:string" select="string($borderTypeAttr)"/>
                <xsl:choose>
                    <xsl:when test="$borderType eq 'none'">
                        <xsl:attribute name="{$borderTypeName}" select="'none'"/>
                    </xsl:when>
                    <xsl:when test="$borderType eq 'single'">
                        <xsl:attribute name="{$borderTypeName}" select="'solid'"/>
                    </xsl:when>
                    <xsl:when test="$borderType eq 'double'">
                        <xsl:attribute name="{$borderTypeName}" select="'double'"/>
                    </xsl:when>
                    <xsl:when test="$borderType eq 'wave'">
                        <xsl:attribute name="{$borderTypeName}" select="'wave'"/>
                    </xsl:when>
                    <xsl:when test="$borderType eq 'dot'">
                        <xsl:attribute name="{$borderTypeName}" select="'dot'"/>
                    </xsl:when>
                    <xsl:when test="$borderType eq 'dash'">
                        <xsl:attribute name="{$borderTypeName}" select="'dash'"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
     function:	get border width
     param:	    prmBorder, prmBorderPos
     return:	attribute()?
     note:	    none
     -->
    <xsl:function name="ahf:getBorderWidth" as="attribute()?">
        <xsl:param name="prmBorder" as="element()"/>
        <xsl:param name="prmBoderPos" as="xs:string"/>
        <xsl:variable name="borderWidthAttr" as="attribute()?" select="$prmBorder/@ahp:width"/>
        <xsl:variable name="borderWidthName" as="xs:string" select="concat($prmBoderPos,'-width')"/>
        <xsl:choose>
            <xsl:when test="exists($borderWidthAttr)">
                <xsl:attribute name="{$borderWidthName}" select="ahf:getLengthFromAttr($borderWidthAttr)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
</xsl:stylesheet>