<?xml version="1.0" encoding="UTF-8"?>
<!--
**************************************************************
AHPDFXML to XSL-FO Stylesheet 
Unit utility Templates
**************************************************************
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL : http://www.antennahouse.co.jp/
**************************************************************
-->

<xsl:stylesheet version="2.0" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="xs ahf ahp" >

    <!-- 画面解像度の既定値 -->
    <xsl:variable name="pxpi" as="xs:double" select="96"/>

    <!-- 
	     convertToMm
	     機能： 単位付の長さを表す文字列をmm値に変換して返す．
	     パラメータ：prmLength
	     備考： 変換可能な単位
	            mm,cm,q,in,pt,pc,px
	            px指定の時は解像度96dpiに固定して計算する．
    -->
    <xsl:function name="ahf:covertToMm" as="xs:double">
        <xsl:param name="prmLength" as="xs:string"/>
        <xsl:choose>
            <xsl:when test="ends-with($prmLength,'mm')">
                <xsl:variable name="mm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'mm')"/>
                <xsl:choose>
                    <xsl:when test="$mm castable as xs:double">
                        <xsl:sequence select="xs:double($mm)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'cm')">
                <xsl:variable name="cm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'cm')"/>
                <xsl:choose>
                    <xsl:when test="$cm castable as xs:double">
                        <xsl:sequence select="xs:double($cm) * 10"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'q') or ends-with($prmLength,'Q')">
                <xsl:variable name="q" as="xs:string" select="ahf:substringBeforeLast(lower-case($prmLength),'q')"/>
                <xsl:choose>
                    <xsl:when test="$q castable as xs:double">
                        <xsl:sequence select="xs:double($q) * 0.25"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'in')">
                <xsl:variable name="in" as="xs:string" select="ahf:substringBeforeLast($prmLength,'in')"/>
                <xsl:choose>
                    <xsl:when test="$in castable as xs:double">
                        <xsl:sequence select="xs:double($in) * 25.4"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pt')">
                <xsl:variable name="pt" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pt')"/>
                <xsl:choose>
                    <xsl:when test="$pt castable as xs:double">
                        <xsl:sequence select="xs:double($pt) * 25.4 div 72"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pc')">
                <xsl:variable name="pc" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pc')"/>
                <xsl:choose>
                    <xsl:when test="$pc castable as xs:double">
                        <xsl:sequence select="xs:double($pc) * 25.4 div 72 * 12"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'px')">
                <xsl:variable name="px" as="xs:string" select="ahf:substringBeforeLast($prmLength,'px')"/>
                <xsl:choose>
                    <xsl:when test="$px castable as xs:double">
                        <xsl:sequence select="xs:double($px) div $pxpi * 25.4"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="warningContinue">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                </xsl:call-template>
                <xsl:sequence select="xs:double(0)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
	     isValidUnitValue
	     機能： 単位付の長さとして有効かをxs:booleanで返します。
	     パラメータ：prmLength
	     備考： 指定可能な単位
	            mm,cm,q,in,pt,pc,px
	            単位なしはptとみなします。
    -->
    <xsl:function name="ahf:isValidUnitValue" as="xs:boolean">
        <xsl:param name="prmLength" as="xs:string"/>
        <xsl:choose>
            <xsl:when test="ends-with($prmLength,'mm')">
                <xsl:variable name="mm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'mm')"/>
                <xsl:choose>
                    <xsl:when test="$mm castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'cm')">
                <xsl:variable name="cm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'cm')"/>
                <xsl:choose>
                    <xsl:when test="$cm castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'q') or ends-with($prmLength,'Q')">
                <xsl:variable name="q" as="xs:string" select="ahf:substringBeforeLast(lower-case($prmLength),'q')"/>
                <xsl:choose>
                    <xsl:when test="$q castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'in')">
                <xsl:variable name="in" as="xs:string" select="ahf:substringBeforeLast($prmLength,'in')"/>
                <xsl:choose>
                    <xsl:when test="$in castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pt')">
                <xsl:variable name="pt" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pt')"/>
                <xsl:choose>
                    <xsl:when test="$pt castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pc')">
                <xsl:variable name="pc" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pc')"/>
                <xsl:choose>
                    <xsl:when test="$pc castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'px')">
                <xsl:variable name="px" as="xs:string" select="ahf:substringBeforeLast($prmLength,'px')"/>
                <xsl:choose>
                    <xsl:when test="$px castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!--単位なしはptとみなします。-->
                <xsl:choose>
                    <xsl:when test="$prmLength castable as xs:double">
                        <xsl:sequence select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
	     convertToPt
	     機能： 単位付の長さを表す文字列をpt値に変換して返す．
	     パラメータ：prmLength
	     備考： 変換可能な単位
	            mm,cm,q,in,pt,pc,px
	            px指定の時は解像度96dpiに固定して計算する．
    -->
    <xsl:function name="ahf:covertToPt" as="xs:double">
        <xsl:param name="prmLength" as="xs:string"/>
        <xsl:choose>
            <xsl:when test="ends-with($prmLength,'mm')">
                <xsl:variable name="mm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'mm')"/>
                <xsl:choose>
                    <xsl:when test="$mm castable as xs:double">
                        <xsl:sequence select="xs:double($mm) div 25.4 * 72"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'cm')">
                <xsl:variable name="cm" as="xs:string" select="ahf:substringBeforeLast($prmLength,'cm')"/>
                <xsl:choose>
                    <xsl:when test="$cm castable as xs:double">
                        <xsl:sequence select="xs:double($cm) div 25.4  * 72 * 10"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'q') or ends-with($prmLength,'Q')">
                <xsl:variable name="q" as="xs:string" select="ahf:substringBeforeLast(lower-case($prmLength),'q')"/>
                <xsl:choose>
                    <xsl:when test="$q castable as xs:double">
                        <xsl:sequence select="xs:double($q) * 0.25 div 25.4 * 72"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'in')">
                <xsl:variable name="in" as="xs:string" select="ahf:substringBeforeLast($prmLength,'in')"/>
                <xsl:choose>
                    <xsl:when test="$in castable as xs:double">
                        <xsl:sequence select="xs:double($in) * 72"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pt')">
                <xsl:variable name="pt" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pt')"/>
                <xsl:choose>
                    <xsl:when test="$pt castable as xs:double">
                        <xsl:sequence select="xs:double($pt)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'pc')">
                <xsl:variable name="pc" as="xs:string" select="ahf:substringBeforeLast($prmLength,'pc')"/>
                <xsl:choose>
                    <xsl:when test="$pc castable as xs:double">
                        <xsl:sequence select="xs:double($pc) * 12"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="ends-with($prmLength,'px')">
                <xsl:variable name="px" as="xs:string" select="ahf:substringBeforeLast($prmLength,'px')"/>
                <xsl:choose>
                    <xsl:when test="$px castable as xs:double">
                        <xsl:sequence select="xs:double($px) div $pxpi * 72"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="warningContinue">
                            <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                        </xsl:call-template>
                        <xsl:sequence select="xs:double(0)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="warningContinue">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes120,('%length'),($prmLength))"/>
                </xsl:call-template>
                <xsl:sequence select="xs:double(0)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>