<?xml version="1.0" encoding="UTF-8" ?>
<!--
**************************************************************
AHPDFXML to XSL-FO Stylesheet 
Utility Templates
**************************************************************
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL : http://www.antennahouse.co.jp/
**************************************************************
-->

<xsl:stylesheet version="2.0" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
 	xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="xs ahf ahp" >

    <!--
    ===============================================
     Utility Templates
    ===============================================
    -->
    
    <!--
    ===============================================
     Error processing
    ===============================================
    -->
    <!-- 
     function:	Error Exit routine
     param:		prmMes: message body
     return:	none
     note:		none
    -->
    <xsl:template name="errorExit">
    	<xsl:param name="prmMes" required="yes" as="xs:string"/>
    	<xsl:message terminate="yes"><xsl:value-of select="$prmMes"/></xsl:message>
    </xsl:template>
    
    
    <!-- 
     function:	Warning display routine
     param:		prmMes: message body
     return:	none
     note:		none
    -->
    <xsl:template name="warningContinue">
    	<xsl:param name="prmMes" required="yes" as="xs:string"/>
    	<xsl:message terminate="no"><xsl:value-of select="$prmMes"/></xsl:message>
    </xsl:template>
    
    <!-- 
      ============================================
         String utility
      ============================================
     -->
    <!--
    function: String Utility
    param: see below
    note: return the sub-string before or after of the LAST delimiter
    -->
    <xsl:template name="substringBeforeLast">
    	<xsl:param name="prmSrcString" required="yes" as="xs:string"/>
    	<xsl:param name="prmDlmString" required="yes" as="xs:string"/>
    	
    	<xsl:variable name="substringBefore" select="substring-before($prmSrcString, $prmDlmString)"/>
    	<xsl:variable name="substringAfter" select="substring-after($prmSrcString, $prmDlmString)"/>
    	<xsl:choose>
    		<xsl:when test="contains($substringAfter, $prmDlmString)">
    			<xsl:variable name="restResult">
    				<xsl:call-template name="substringBeforeLast">
    					<xsl:with-param name="prmSrcString" select="$substringAfter"/>
    					<xsl:with-param name="prmDlmString" select="$prmDlmString"/>
    				</xsl:call-template>
    			</xsl:variable>
    			<xsl:value-of select="concat($substringBefore, $prmDlmString, $restResult)"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:value-of select="$substringBefore"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:function name="ahf:substringBeforeLast" as="xs:string">
        <xsl:param name="prmSrcString" as="xs:string"/>
        <xsl:param name="prmDlmString" as="xs:string"/>
        
        <xsl:variable name="substringBefore" select="substring-before($prmSrcString, $prmDlmString)"/>
        <xsl:variable name="substringAfter" select="substring-after($prmSrcString, $prmDlmString)"/>
        <xsl:choose>
            <xsl:when test="contains($substringAfter, $prmDlmString)">
                <xsl:variable name="restResult" as="xs:string" select="ahf:substringBeforeLast($substringAfter,$prmDlmString)"/>
                <xsl:sequence select="concat($substringBefore, $prmDlmString, $restResult)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="$substringBefore"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="ahf:substringAfterLast" as="xs:string">
    	<xsl:param name="prmSrcString" as="xs:string"/>
    	<xsl:param name="prmDlmString" as="xs:string"/>
    	
    	<xsl:variable name="substringBefore" select="substring-before($prmSrcString, $prmDlmString)"/>
    	<xsl:variable name="substringAfter" select="substring-after($prmSrcString, $prmDlmString)"/>
    	<xsl:choose>
    		<xsl:when test="not(contains($prmSrcString, $prmDlmString))">
    			<xsl:sequence select="$prmSrcString"/>
    		</xsl:when>
    		<xsl:when test="contains($substringAfter, $prmDlmString)">
    			<xsl:sequence select="ahf:substringAfterLast($substringAfter, $prmDlmString)"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:sequence select="$substringAfter"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:function>
    
    <!--
        function: Convert back-slash to slash
        param: prmString
        note: Result string
    -->
    <xsl:function name="ahf:bsToSlash" as="xs:string">
        <xsl:param name="prmStr" as="xs:string"/>
        <xsl:sequence select="translate($prmStr,'&#x005C;','/')"/>
    </xsl:function>
    
    <!--
        function: Safe replace function
        param: prmStr,prmSrc,prmDst
        note: Result string
    -->
    <xsl:function name="ahf:safeReplace" as="xs:string">
        <xsl:param name="prmStr" as="xs:string"/>
        <xsl:param name="prmSrc" as="xs:string"/>
        <xsl:param name="prmDst" as="xs:string"/>
        <xsl:sequence select="replace($prmStr,$prmSrc,ahf:bsToSlash($prmDst))"/>
    </xsl:function>
    
    <!--
        function: Multiple replace function
        param: prmStr,prmSrc,prmDst
        note: Result string
    -->
    <xsl:function name="ahf:replace" as="xs:string">
        <xsl:param name="prmStr" as="xs:string"/>
        <xsl:param name="prmSrc" as="xs:string+"/>
        <xsl:param name="prmDst" as="xs:string+"/>
    
        <xsl:variable name="firstResult" select="ahf:safeReplace($prmStr,$prmSrc[1],$prmDst[1])" as="xs:string"/>
        <xsl:choose>
            <xsl:when test="exists($prmSrc[2]) and exists($prmDst[2])">
                <xsl:sequence select="ahf:replace($firstResult,subsequence($prmSrc,2),subsequence($prmDst,2))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="$firstResult"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    
    <!-- 
      ============================================
         Other functions
      ============================================
    -->
    <!-- 
     function:	Make hexadecimal string from positive integer
     param:		prmNumber
     return:	Hexadecimal string
     note:		
     -->
    <xsl:function name="ahf:intToHexString" as="xs:string">
        <xsl:param name="prmValue" as="xs:integer"/>
    
        <xsl:variable name="quotient"  select="$prmValue idiv 16" as="xs:integer"/>
        <xsl:variable name="remainder" select="$prmValue mod 16"  as="xs:integer"/>
        
        <xsl:variable name="quotientString" select="if ($quotient &gt; 0) then (ahf:intToHexString($quotient)) else ''" as="xs:string"/>
        <xsl:variable name="remainderString" as="xs:string">
            <xsl:choose>
                <xsl:when test="($remainder &gt;= 0) and ($remainder &lt;= 9)">
                    <xsl:value-of select="format-number($remainder, '0')"/>
                </xsl:when>
                <xsl:when test="$remainder = 10">
                    <xsl:value-of select="'A'"/>
                </xsl:when>
                <xsl:when test="$remainder = 11">
                    <xsl:value-of select="'B'"/>
                </xsl:when>
                <xsl:when test="$remainder = 12">
                    <xsl:value-of select="'C'"/>
                </xsl:when>
                <xsl:when test="$remainder = 13">
                    <xsl:value-of select="'D'"/>
                </xsl:when>
                <xsl:when test="$remainder = 14">
                    <xsl:value-of select="'E'"/>
                </xsl:when>
                <xsl:when test="$remainder = 15">
                    <xsl:value-of select="'F'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="''"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="concat($quotientString, $remainderString)"/>
    </xsl:function>
    
    <!-- 
     function:	Make hexadecimal string from codepoint sequence
     param:		prmCodePoint
     return:	Hexadecimal string
     note:		
     -->
    <xsl:function name="ahf:codepointToHexString" as="xs:string">
        <xsl:param name="prmCodePoint" as="xs:integer*"/>
    
        <xsl:choose>
            <xsl:when test="empty($prmCodePoint)">
                <xsl:sequence select="''"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="first" select="ahf:intToHexString($prmCodePoint[1])" as="xs:string"/>
                <xsl:variable name="paddingCount" select="string-length($first) mod 4"/>
                <xsl:variable name="paddingZero" select="if ($paddingCount gt 0) then string-join(for $i in 1 to $paddingCount return '0','') else ''"/>
                <xsl:variable name="rest"  select="ahf:codepointToHexString(subsequence($prmCodePoint,2))" as="xs:string"/>
                <xsl:sequence select="concat($paddingZero, $first, $rest)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <!-- 
     function:	Make hexadecimal string from string
     param:		prmString
     return:	Hexadecimal string
     note:		
     -->
    <xsl:function name="ahf:stringToHexString" as="xs:string">
        <xsl:param name="prmString" as="xs:string"/>
    
        <xsl:variable name="codePoints" select="string-to-codepoints($prmString)" as="xs:integer*"/>
        <xsl:sequence select="ahf:codepointToHexString($codePoints)"/>
    </xsl:function>
    
    <!-- 
     function:	Get length from ahp:lengthType
     param:		prmLength
     return:	Length with unit
     note:		
     -->
    <xsl:function name="ahf:getLength" as="xs:string">
        <xsl:param name="prmLength" as="xs:string"/>
        <xsl:sequence select="concat($prmLength,$ahpLengthUnit)"/>
    </xsl:function>

    <!-- 
     function:	Get length from attribute()
     param:		prmAttr
     return:	Length with unit
     note:		
     -->
    <xsl:function name="ahf:getLengthFromAttr" as="xs:string">
        <xsl:param name="prmAttr" as="attribute()"/>
        <xsl:sequence select="ahf:getLength(string($prmAttr))"/>
    </xsl:function>

    <!-- 
     function:	Get coordinate value from ahp:positionType
     param:		prmPosition
     return:	Coordinate value with unit
     note:		
     -->
    <xsl:function name="ahf:getPosition" as="xs:string">
        <xsl:param name="prmPosition" as="xs:string"/>
        <xsl:sequence select="concat($prmPosition,$ahpPositionUnit)"/>
    </xsl:function>
    

    <!-- 
     function:	Get absolute coordinate value from ahp:positionType attribute
     param:		prmPosAttr
     return:	Coordinate value with unit
     note:		
     -->
    <xsl:function name="ahf:getAbsPosFromAttr" as="xs:string">
        <xsl:param name="prmPosAttr" as="attribute()"/>
        <xsl:sequence select="ahf:getPosition(string($prmPosAttr))"/>
    </xsl:function>

    <!-- 
     function:	Get relative coordinate value from two ahp:positionType attribute
     param:		prmParentPosAttr prmPosAttr
     return:	Coordinate value with unit
     note:		
     -->
    <xsl:function name="ahf:getRelativePosFromAttr" as="xs:string">
        <xsl:param name="prmParentPosAttr" as="attribute()"/>
        <xsl:param name="prmPosAttr" as="attribute()"/>
        <xsl:variable name="parentPos" as="xs:double" select="xs:double(string($prmParentPosAttr))"/>
        <xsl:variable name="pos" as="xs:double" select="xs:double(string($prmPosAttr))"/>
        <xsl:variable name="relativePos" as="xs:double" select="$pos - $parentPos"/>
        <xsl:sequence select="ahf:getPosition(string($relativePos))"/>
    </xsl:function>

    <xsl:function name="ahf:getRelativePosFromAttrReverse" as="xs:string">
        <xsl:param name="prmParentPosAttr" as="attribute()"/>
        <xsl:param name="prmPosAttr" as="attribute()"/>
        <xsl:variable name="parentPos" as="xs:double" select="xs:double(string($prmParentPosAttr))"/>
        <xsl:variable name="pos" as="xs:double" select="xs:double(string($prmPosAttr))"/>
        <xsl:variable name="relativePos" as="xs:double" select="$parentPos - $pos"/>
        <xsl:sequence select="ahf:getPosition(string($relativePos))"/>
    </xsl:function>
    

    <!-- 
     function:	Get length value from two ahp:positionType attribute
     param:		prmFirstPosAttr prmSecondPosAttr
     return:	Length value with unit
     note:		$prmSecondPosAttr > $prmFirstPosAttr
     -->
    <xsl:function name="ahf:getLength" as="xs:string">
        <xsl:param name="prmFirstPosAttr" as="attribute()"/>
        <xsl:param name="prmSecondPosAttr" as="attribute()"/>
        <xsl:variable name="firstPos" as="xs:double" select="xs:double(string($prmFirstPosAttr))"/>
        <xsl:variable name="secondPos" as="xs:double" select="xs:double(string($prmSecondPosAttr))"/>
        <xsl:variable name="length" as="xs:double" select="$secondPos - $firstPos"/>
        <xsl:sequence select="ahf:getLength(string($length))"/>
    </xsl:function>
    
    <!-- 
     function:	Get element history string
     param:		prmElem
     return:	xs:string
     note:		
     -->
    <xsl:function name="ahf:getHistory" as="xs:string">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="ancestorElem" as="element()+" select="$prmElem/ancestor-or-self::*"/>
        <xsl:variable name="historyStr" as="xs:string*">
            <xsl:for-each select="$ancestorElem">
                <xsl:variable name="elem" select="."/>
                <xsl:variable name="name" as="xs:string" select="name()"/>
                <xsl:sequence select="if (position() gt 1) then '/' else ''"/>
                <xsl:sequence select="local-name()"/>
                <xsl:sequence select="if (exists($elem/parent::*)) then concat('[',string(count($elem/preceding-sibling::*[name() eq $name]) + 1),']') else ''"/>
            </xsl:for-each>
        </xsl:variable>
        <xsl:sequence select="string-join($historyStr,'')"/>
    </xsl:function>

    <!-- 
     function:	Get element history as comment
     param:		prmElem
     return:	comment()
     note:		
     -->
    <xsl:function name="ahf:getHistoryComment" as="comment()">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:comment><xsl:value-of select="ahf:getHistory($prmElem)"/></xsl:comment>
    </xsl:function>

    <!-- end of stylesheet -->
</xsl:stylesheet>
