<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to HTML5 Stylesheet
Module: Document template
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 exclude-result-prefixes="ahf ahp xs">
    
    <!-- 
     function:	page template
     param:	    none
     return:	div
     note:	    none
     -->
    <xsl:template match="ahp:page">
        <xsl:variable name="page" as="element()" select="."/>
        <xsl:choose>
            <xsl:when test="$glIsMultiPage">
                <xsl:variable name="href" as="xs:string" select="string(resolve-uri(ahf:getPageHtmlName($page), $outputFileUri))"/>
                <xsl:result-document method="html" doctype-system="about:legacy-compat" encoding="UTF-8" indent="no" href="{$href}">
                    <html>
                        <head>
                            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                            <title>
                                <xsl:value-of select="concat($glDocumentDoc/ahp:document/@ahp:title,'- Page ',ahf:getPageNumber($page))"/>
                            </title>
                            <link charset="UTF-8" rel="stylesheet" href="{$prmCssFile}" type="text/css"/>
                        </head>
                        <body>
                            <xsl:copy-of select="ahf:getHistoryComment(.)"/>
                            <div>
                                <xsl:variable name="pageAttr" as="attribute()+">
                                    <xsl:attribute name="page" select="ahf:getPageName($page)"/>
                                </xsl:variable>
                                <xsl:copy-of select="ahf:getCssStyleAttr($pageAttr)"/>
                                <xsl:apply-templates/>
                            </div>
                        </body>
                    </html>
                </xsl:result-document>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="ahf:getHistoryComment(.)"/>
                <div>
                    <xsl:variable name="pageAttr" as="attribute()+">
                        <xsl:attribute name="page" select="ahf:getPageName($page)"/>
                    </xsl:variable>
                    <xsl:copy-of select="ahf:getCssStyleAttr($pageAttr)"/>
                    <xsl:apply-templates/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- 
     function:	section template
     param:	    none
     return:	div
     note:	    none
     -->
    <xsl:template match="ahp:section">
        <xsl:variable name="section" as="element()" select="."/>
        <xsl:variable name="page" as="element()" select="$section/parent::ahp:page"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <div>
            <xsl:copy-of select="ahf:getClassAttr($section/@ahp:s-id)"/>
            <xsl:variable name="sectionAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getAbsPosFromAttr($section/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($page/@ahp:height,$section/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getAbsPosFromAttr($section/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($page/@ahp:width,$section/@ahp:r)"/>
                <xsl:copy-of select="ahf:getWritingModeAttr($section)"/>
            </xsl:variable>
            <xsl:copy-of select="ahf:getCssStyleAttr($sectionAttr)"/>
            <xsl:apply-templates select="* except ahp:section-column"/>
        </div>
    </xsl:template>

    <!-- 
     function:	frame template
     param:	    none
     return:	div
     note:	    none
     -->
    <xsl:template match="ahp:frame">
        <xsl:variable name="frame" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$frame/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <div>
            <xsl:copy-of select="ahf:getClassAttr($frame/@ahp:s-id)"/>
            <xsl:variable name="frameAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$frame/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$frame/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$frame/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$frame/@ahp:r)"/>
                <xsl:copy-of select="ahf:getWritingModeAttr($frame)"/>
                <xsl:copy-of select="ahf:getZOrder($frame)"/>
            </xsl:variable>
            <xsl:copy-of select="ahf:getCssStyleAttr($frameAttr)"/>
            <xsl:choose>
                <xsl:when test="string($frame/@ahp:frame-type) = ('image','svg')">
                    <xsl:variable name="href" as="xs:string" select="ahf:getExtrenalGraphicPath(string($frame/@ahp:file-id))"/>
                    <img src="{$href}">
                        <xsl:attribute name="width" select="ahf:getLength($frame/@ahp:l,$frame/@ahp:r)"/>
                        <xsl:attribute name="height" select="ahf:getLength($frame/@ahp:t,$frame/@ahp:b)"/>
                    </img>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
 
    <!-- 
     function:	p template
     param:	    none
     return:	div
     note:	    none
     -->
    <xsl:template match="ahp:p">
        <xsl:variable name="p" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$p/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <div>
            <xsl:copy-of select="ahf:getClassAttr($p/@ahp:s-id)"/>
            <xsl:variable name="pAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$p/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$p/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$p/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$p/@ahp:r)"/>
            </xsl:variable>
            <xsl:if test="exists($p/parent::ahp:frame)">
                <xsl:copy-of select="ahf:getCssStyleAttr($pAttr)"/>
            </xsl:if>
            <xsl:apply-templates/>
        </div>
    </xsl:template>

    <!-- 
     function:	line template
     param:	    none
     return:	span
     note:	    none
     -->
    <xsl:template match="ahp:line">
        <xsl:variable name="line" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$line/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <span>
            <xsl:variable name="lineAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$line/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$line/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$line/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$line/@ahp:r)"/>
            </xsl:variable>
            <xsl:if test="exists($line/parent::ahp:p/parent::ahp:frame)">
                <xsl:copy-of select="ahf:getCssStyleAttr($lineAttr)"/>
            </xsl:if>
            <xsl:apply-templates/>
        </span>
        <xsl:if test="exists($line/parent::ahp:p/parent::ahp:cell) and exists($line/following-sibling::ahp:line)">
            <br/>
        </xsl:if>
    </xsl:template>

    <!-- 
     function:	run template
     param:	    none
     return:	span
     note:	    none
     -->
    <xsl:template match="ahp:run">
        <xsl:variable name="run" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$run/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <span>
            <xsl:copy-of select="ahf:getClassAttr($run/@ahp:s-id)"/>
            <xsl:variable name="frameAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$run/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$run/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$run/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$run/@ahp:r)"/>
            </xsl:variable>
            <xsl:apply-templates/>
        </span>
    </xsl:template>

    <!-- 
     function:	table template
     param:	    none
     return:	table
     note:      table以降だけはHTMLのtable/row/cellに変換してあります。
                なのでXSL-FOに比べて少しくずれます。
     -->
    <xsl:template match="ahp:table">
        <xsl:variable name="table" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$table/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <table>
            <xsl:copy-of select="ahf:getClassAttr($table/@ahp:s-id)"/>
            <xsl:variable name="tableAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$table/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$table/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$table/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$table/@ahp:r)"/>
            </xsl:variable>
            <xsl:attribute name="width" select="ahf:getLength($table/@ahp:l,$table/@ahp:r)"/>
            <xsl:apply-templates select="* except ahp:table-column"/>
        </table>
    </xsl:template>

    <!-- 
     function:	row template
     param:	    none
     return:	tr
     note:	    none
     -->
    <xsl:template match="ahp:row">
        <xsl:variable name="row" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$row/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <tr>
            <xsl:copy-of select="ahf:getClassAttr($row/@ahp:s-id)"/>
            <xsl:variable name="rowAttrtr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$row/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$row/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$row/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$row/@ahp:r)"/>
            </xsl:variable>
            <xsl:apply-templates/>
        </tr>
    </xsl:template>
    
    <!-- 
     function:	cell template
     param:	    none
     return:	td
     note:	
     -->
    <xsl:template match="ahp:cell">
        <xsl:variable name="cell" as="element()" select="."/>
        <xsl:variable name="parent" as="element()" select="$cell/parent::*"/>
        <xsl:copy-of select="ahf:getHistoryComment(.)"/>
        <td>
            <xsl:copy-of select="ahf:getClassAttr($cell/@ahp:s-id)"/>
            <xsl:variable name="cellAttr" as="attribute()+">
                <xsl:sequence select="$absPosAttr"/>
                <xsl:attribute name="top" select="ahf:getRelativePosFromAttr($parent/@ahp:t,$cell/@ahp:t)"/>
                <xsl:attribute name="bottom" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:b,$cell/@ahp:b)"/>
                <xsl:attribute name="left" select="ahf:getRelativePosFromAttr($parent/@ahp:l,$cell/@ahp:l)"/>
                <xsl:attribute name="right" select="ahf:getRelativePosFromAttrReverse($parent/@ahp:r,$cell/@ahp:r)"/>
            </xsl:variable>
            <xsl:apply-templates/>
        </td>
    </xsl:template>

    <!-- 
     function:	get writing-mode
     param:	    prmElem
     return:	attribute()
     note:	    writing-modeはベンダー依存。"-"を最初に書くとQNameにならないので暫定的に"_"をつけて
                CSSに落とすときに削除します。
     -->
    <xsl:function name="ahf:getWritingModeAttr" as="attribute()*">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="writingMode" as="xs:string" select="string($prmElem/@ahp:writing-mode)"/>
        <xsl:choose>
            <xsl:when test="$writingMode eq 'vertical'">
                <xsl:attribute name="writing-mode" select="'vertical-rl'"/>
                <xsl:attribute name="_-moz-writing-mode" select="'vertical-rl'"/>
                <xsl:attribute name="_-o-writing-mode" select="'vertical-rl'"/>
                <xsl:attribute name="_-webkit-writing-mode" select="'vertical-rl'"/>
            </xsl:when>
            <xsl:when test="$writingMode eq 'horizontal'">
                <xsl:attribute name="writing-mode" select="'horizontal-tb'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get z-orfder
     param:	    prmElem
     return:	attribute()?
     note:	    none
     -->
    <xsl:function name="ahf:getZOrder" as="attribute()?">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:variable name="zOrder" as="xs:string" select="string($prmElem/@ahp:z-order)"/>
        <xsl:choose>
            <xsl:when test="string($zOrder)">
                <xsl:attribute name="z-order" select="$zOrder"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <!-- 
     function:	get column-count
     param:	    prmElem
     return:	attribute()
     note:	    none
     -->
    <xsl:function name="ahf:getColumCountAttr" as="attribute()">
        <xsl:param name="prmElem" as="element()"/>
        <xsl:attribute name="column-count" select="string($prmElem/@ahp:section-column-count)"/>
    </xsl:function>

    <!-- 
     function:	get external graphic path
     param:	    prmElem
     return:	xs:string
     note:	    none
     -->
    <xsl:function name="ahf:getExtrenalGraphicPath" as="xs:string">
        <xsl:param name="prmId" as="xs:string"/>
        <!--xsl:variable name="content" as="element()?" select="key('keyContentById',$prmId,$glContents)[1]"/-->
        <xsl:variable name="href" as="attribute()?" select="$glContents/ahp:content[string(@ahp:id) eq $prmId]/@ahp:href"/>
        <xsl:choose>
            <xsl:when test="exists($href)">
                <xsl:sequence select="string($href)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="''"/>
                <xsl:call-template name="errorExit">
                    <xsl:with-param name="prmMes" select="ahf:replace($stMes003,('%id','%file'),($prmId,string(document-uri($glContents))))"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
