<?xml version="1.0" encoding="UTF-8"?>
<!--
****************************************************************
AHPDFXML to HTML5 Stylesheet
Module: Generate page style.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="ahp">
    
    <!-- 
     function:	generate page style
     param:		none
     return:	ahp:style-def
     note:		none
    -->
    
    <xsl:template name="genPageStyle">
        <xsl:for-each select="$glDocumentDoc/ahp:document/ahp:page">
            <xsl:variable name="page" as="element()" select="."/>
            <ahp:style-def>
                <xsl:attribute name="ahp:name" select="'@page'"/>
                <xsl:attribute name="ahp:id" select="ahf:getPageName($page)"/>
                <xsl:attribute name="size" select="concat(ahf:getLengthFromAttr($page/@ahp:width),' ',ahf:getLengthFromAttr($page/@ahp:height))"/>
            </ahp:style-def>
        </xsl:for-each>
    </xsl:template>
    
    <!-- 
     function:	generate page name
     param:		page
     return:	xs:string
     note:		none
    -->
    <xsl:function name="ahf:getPageName" as="xs:string">
        <xsl:param name="prmPage" as="element()"/>
        <xsl:sequence select="concat('page_',generate-id($prmPage))"/>
    </xsl:function>
    
    <!-- 
     function:	generate html file name per page
     param:		page
     return:	xs:string
     note:		複数ページのときpageをパラメータとして出力HTMLのファイル名を求めます。
    -->
    <xsl:function name="ahf:getPageHtmlName" as="xs:string">
        <xsl:param name="prmPage" as="element()"/>
        <xsl:variable name="pageNumber" as="xs:string" select="string(count($prmPage/preceding-sibling::*) + 1)"/>
        <xsl:sequence select="concat($glOutputFileWoExt,'_',$pageNumber,'.',$glOutputFileExt)"/>
    </xsl:function>
    
    <!-- 
     function:	generate page number
     param:		page
     return:	xs:string
     note:		複数ページのときpageをパラメータとしてページ番号を得ます。
    -->
    <xsl:function name="ahf:getPageNumber" as="xs:string">
        <xsl:param name="prmPage" as="element()"/>
        <xsl:sequence select="string(count($prmPage/preceding-sibling::*) + 1)"/>
    </xsl:function>
    
</xsl:stylesheet>
