<?xml version="1.0" encoding="UTF-8"?>
<!--
****************************************************************
AHPDFXML to HTML5 Stylesheet
Module: Parameter
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
    xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
    exclude-result-prefixes="xs ahf ahp">
    
    <xsl:param name="prmCssFile" as="xs:string" required="yes"/>
    <xsl:variable name="cssFileEscaped" as="xs:string" select="translate($prmCssFile,'\','/')"/>
    <xsl:variable name="cssUrl" as="xs:string" select="resolve-uri($cssFileEscaped, $outputFileUri)"/>

    <xsl:param name="prmOutputFile" as="xs:string" required="yes"/>
    <xsl:variable name="outputFilePath" as="xs:string" select="translate($prmOutputFile,'\','/')"/>
    <xsl:variable name="outputFileUri" as="xs:string">
        <xsl:sequence select="concat('file:/',$outputFilePath)"/>
    </xsl:variable>
    <xsl:variable name="glOutputFileWoExt" as="xs:string" select="ahf:substringAfterLast(ahf:substringBeforeLast($outputFilePath,'.'),'/')"/>
    <xsl:variable name="glOutputFileExt" as="xs:string" select="ahf:substringAfterLast($outputFilePath,'.')"/>
    
</xsl:stylesheet>