<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to text Stylesheet
Module: Main control.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:fo="http://www.w3.org/1999/XSL/Format" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:axf="http://www.antennahouse.com/names/XSL/Extensions"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 exclude-result-prefixes="ahf">
    
    <!-- 
     function:	page template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:page">
        <xsl:apply-templates select="*"/>
    </xsl:template>

    <!-- 
     function:	section template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:section">
        <xsl:apply-templates select="* except ahp:section-column"/>
    </xsl:template>

    <!-- 
     function:	frame template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:frame">
        <xsl:variable name="frame" select="."/>
        <xsl:choose>
            <xsl:when test="string($frame/@ahp:frame-type) = ('image','svg')">
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="*"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
 
    <!-- 
     function:	p template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:p">
        <xsl:variable name="p" as="element()" select="."/>
        <xsl:variable name="texts" as="xs:string*">
            <xsl:apply-templates select="*"/>
        </xsl:variable>
        <xsl:variable name="text" as="xs:string" select="string-join($texts,'')"/>
        <xsl:choose>
            <xsl:when test="$glIsRemoveEmptyLine">
                <xsl:choose>
                    <xsl:when test="string(normalize-space($text))">
                        <xsl:value-of select="$text"/>
                        <xsl:value-of select="$cCRLF"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:sequence select="()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text"/>
                <xsl:value-of select="$cCRLF"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- 
     function:	line template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:line">
        <xsl:apply-templates select="*"/>
    </xsl:template>

    <!-- 
     function:	run template
     param:	none
     return:	
     note:	none
     -->
    <xsl:template match="ahp:run">
        <xsl:variable name="run" as="element()" select="."/>
        <xsl:sequence select="string(.)"/>
    </xsl:template>

    <!-- 
     function:	table template
     param:	none
     return:	
     note:	
     -->
    <xsl:template match="ahp:table">
        <xsl:variable name="table" as="element()" select="."/>
        <xsl:apply-templates select="* except ahp:table-column"/>
    </xsl:template>
    
    <!-- 
     function:	row template
     param:	none
     return:	
     note:	
     -->
    <xsl:template match="ahp:row">
        <xsl:variable name="row" as="element()" select="."/>
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <!-- 
     function:	cell template
     param:	none
     return:	
     note:	
     -->
    <xsl:template match="ahp:cell">
        <xsl:variable name="cell" as="element()" select="."/>
        <xsl:apply-templates select="*"/>
    </xsl:template>

</xsl:stylesheet>
