<?xml version='1.0' encoding="UTF-8" ?>
<!--
****************************************************************
AHPDFXML to HTML5 Stylesheet
Module: Main control.
Copyright © 2014-2014 Antenna House, Inc. All rights reserved.
Antenna House is a trademark of Antenna House, Inc.
URL    : http://www.antennahouse.com/
E-mail : info@antennahouse.com
****************************************************************
-->
<xsl:stylesheet version="2.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
 xmlns:ahf="http://www.antennahouse.com/names/XSLT/Functions/Document"
 xmlns:ahp="http://www.antennahouse.com/names/PDF/AHPDFXML"
 xmlns="http://www.w3.org/1999/xhtml"
 exclude-result-prefixes="ahf ahp xs" 
>
    
    <!-- 
     function:	root matching template
     param:		none
     return:	fo:root
     note:		none
     -->
    <xsl:template match="/">
        
        <!--Output CSS -->
        <xsl:result-document method="text" encoding="UTF-8" byte-order-mark="no" href="{$cssUrl}">
            <xsl:copy-of select="$glCSSPageDef"/>
            <xsl:copy-of select="$glCssStyleDef"/>
        </xsl:result-document>

        <xsl:choose>
            <xsl:when test="$glIsMultiPage">
                <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html></xsl:text>
                <html>
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                        <title>
                            <xsl:value-of select="$glDocumentDoc/ahp:document/@ahp:title"/>
                        </title>
                        <link charset="UTF-8" rel="stylesheet" href="{$prmCssFile}" type="text/css"/>
                    </head>
                    <body>
                        <xsl:for-each select="$glDocumentDoc/ahp:document/ahp:page">
                            <xsl:variable name="pageHtmlFile" as="xs:string" select="ahf:getPageHtmlName(.)"/>
                            <xsl:variable name="pageNumber" as="xs:string" select="ahf:getPageNumber(.)"/>
                            <p><a href="{$pageHtmlFile}">Page <xsl:value-of select="$pageNumber"/></a></p>
                        </xsl:for-each>
                    </body>
                </html>
                <xsl:apply-templates select="$glDocumentDoc/ahp:document"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html></xsl:text>
                <html>
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                        <title>
                            <xsl:value-of select="$glDocumentDoc/ahp:document/@ahp:title"/>
                        </title>
                        <link charset="UTF-8" rel="stylesheet" href="{$prmCssFile}" type="text/css"/>
                    </head>
                    <body>
                        <xsl:apply-templates select="$glDocumentDoc/ahp:document"/>
                    </body>
                </html>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
