﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：1ページ目に、指定した画像を使ったステンシルマスクをかけます。
  　　　ステンシルマスクで塗りつぶす色はRGBで指定することができます。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddImageSetSoftMask
    {
        public static void Main(String[] args)
        {
            if (args.Length < 4)
            {
                Console.WriteLine("usage: AddImageSetSoftMask in-pdf-file out-pdf-file insert-image-file mask-file");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    //コマンドライン引数の取得
                    String imageURI = args[2];
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);
                    String softMaskFile = args[3];

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0))// 先頭ページの取得(パラメータindexは0が先頭)
                        using (PtlContent content = page.getContent())// ページコンテントの取得
                        using (PtlRect outputRect = page.getViewBox()) // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                        using (PtlParamInput insertImage = new PtlParamInput(imageURI)) //画像指定に使うパラメータクラス
                        using (PtlParamInput insertMask = new PtlParamInput(softMaskFile))
                        using (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage()) //画像の描画に使うパラメータクラス
                        {
                            //入力画像ストリームの設定
                            paramDrawImage.setImageStream(insertImage);
                            paramDrawImage.setMaskImageStream(insertMask, PtlParamDrawImage.MASK_TYPE.MASK_SOFT);
                            // 画像出力
                            content.drawImage(outputRect, PtlContent.ALIGN.ALIGN_CENTER, paramDrawImage);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
