﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：指定したページの指定した始点・終点に線を引きます。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddLine
    {
        public static void Main(String[] args)
        {
            if (args.Length < 9)
            {
                Console.WriteLine("usage: AddLine in-pdf-file out-pdf-file page-num line-style line-width colorR colorG colorB opacity");
                Console.WriteLine("line-style:\n 0: 実線, 1: 破線");
                Console.WriteLine("line-width:\n 0: 細い, 1: 中, 2:太い");
                return;
            }

            // line-styleの判定
            int lineStyle = int.Parse(args[3]);
            switch (lineStyle)
            {
                case 0:
                case 1:
                    break;
                default:
                    Console.WriteLine("line-styleには0か1の数値を指定してください。");
                    Console.WriteLine("usage: AddLine in-pdf-file out-pdf-file page-num line-style line-width colorR colorG colorB opacity");
                    Console.WriteLine("line-style:\n 0: 実線, 1: 破線");
                    Console.WriteLine("line-width:\n 0: 細い, 1: 中, 2:太い");
                    return;
            }

            // line-widthの判定
            int lineWidth = int.Parse(args[4]);
            switch (lineWidth)
            {
                case 0:
                case 1:
                case 2:
                    break;
                default:
                    Console.WriteLine("line-widthには0から2の数値を指定してください。");
                    Console.WriteLine("usage: AddLine in-pdf-file out-pdf-file page-num line-style line-width colorR colorG colorB opacity");
                    Console.WriteLine("line-style:\n 0: 実線, 1: 破線");
                    Console.WriteLine("line-width:\n 0: 細い, 1: 中, 2:太い");
                    return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    //コマンドライン引数の取得
                    int pageToAdd = int.Parse(args[2]);
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);
                    if ((numPages < 0) || (numPages < pageToAdd))
                    {
                        Console.WriteLine("page-numは入力PDFの全ページ数よりも小さい正の値を指定してください。");
                        return;
                    }
                    float colorR = float.Parse(args[5]);
                    float colorG = float.Parse(args[6]);
                    float colorB = float.Parse(args[7]);
                    float opacity = float.Parse(args[8]);


                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("入力PDFのページコンテナが空");
                            return;
                        }
                        // フォームの描画処理（）
                        using (PtlPage page = pages.get(pageToAdd - 1))// ページの取得(パラメータindexは0が先頭のため1を引く)
                        {
                            drawLineOnPage(page, lineStyle, lineWidth, colorR, colorG, colorB, opacity);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static void drawLineOnPage(PtlPage page, int lineStyle, int lineWidth, float colorR, float colorG, float colorB, float opacity)
        {
            Console.WriteLine("線の始点を設定します。");
            using (PtlPoint startPoint = new PtlPoint(setPoint())) // 始点の設定（setPointを用いて初期化）
            {
                Console.WriteLine("線の終点を設定します。");
                using (PtlPoint endPoint = new PtlPoint(setPoint())) // 始点の設定（setPointを用いて初期化）
                {
                    using (PtlContent content = page.getContent()) // ページコンテントの取得
                    using (PtlColorDeviceRGB colorRGB = new PtlColorDeviceRGB(colorR, colorG, colorB)) //色を指定
                    using (PtlParamDrawShape paramDrawShape = new PtlParamDrawShape()) // 線の描画用パラメータクラス
                    {
                        paramDrawShape.setLineColor(colorRGB); // 線の色を指定色に設定
                        paramDrawShape.setOpacity(opacity); // 透明度を設定

                        // lineStyleの設定
                        switch (lineStyle)
                        {
                            case 0:
                                paramDrawShape.setLineStyle(PtlParamDrawShape.LINE_STYLE.LINE_STYLE_SOLID);
                                break;
                            case 1:
                                paramDrawShape.setLineStyle(PtlParamDrawShape.LINE_STYLE.LINE_STYLE_DASHED);
                                break;
                        }

                        // lineWidthの設定
                        switch (lineWidth)
                        {
                            case 0:
                                paramDrawShape.setLineWidth(PtlParamDrawShape.LINE_WIDTH.LINE_WIDTH_THIN);
                                break;
                            case 1:
                                paramDrawShape.setLineWidth(PtlParamDrawShape.LINE_WIDTH.LINE_WIDTH_MIDDLE);
                                break;
                            case 2:
                                paramDrawShape.setLineWidth(PtlParamDrawShape.LINE_WIDTH.LINE_WIDTH_THICK);
                                break;
                        }
                        // 指定ページの挿入
                        content.drawLine(startPoint, endPoint, paramDrawShape);
                    }
                }
            }
        }

        public static PtlPoint setPoint()
        {
            float x, y;

            Console.WriteLine("x座標、y座標を入力してください。原点は用紙の左下です。");
            Console.Write("x (mm) : ");
            x = float.Parse(Console.ReadLine());
            Console.Write("y (mm) : ");
            y = float.Parse(Console.ReadLine());

            PtlPoint pointToSet = new PtlPoint(x, y);
            return pointToSet;
        }
    }
}
