﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：周囲に余白を追加

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddMargin
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AddMargin in-pdf-file out-pdf-file size-of-margin");
                return;
            }


            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);
                    int numPages = doc.getPageCount();
                    Console.WriteLine("全" + numPages + "ページに余白を追加します。");

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }
                        for (int i = 0; i < numPages; i++)
                        {
                            // ページの取得
                            // PtlPages.get() のパラメータindexは0が先頭
                            using (PtlPage page = pages.get(i))
                            using (PtlSize sizeOfPage = page.getSize())//サイズを取得
                            {
                                float trimBoxWidth = sizeOfPage.getWidth();
                                float trimBoxHeight = sizeOfPage.getHeight();
                                float sizeOfMargin = float.Parse(args[2]);

                                float top, bottom, left, right;

                                //TrimBox
                                left = 0;
                                bottom = 0;
                                right = trimBoxWidth;
                                top = trimBoxHeight;
                                using (PtlRect trimBox = new PtlRect(left, bottom, right, top))
                                {
                                    //TrimBoxの設定
                                    page.setTrimBox(trimBox);
                                }


                                //BleedBox
                                left = left - 3;
                                bottom = bottom - 3;
                                right = right + 3;
                                top = top + 3;
                                using (PtlRect bleedBox = new PtlRect(left, bottom, right, top))
                                {
                                    //BleedBoxの値の設定
                                    page.setBleedBox(bleedBox);
                                }

                                //MediaBox,CropBox
                                left = left - sizeOfMargin;
                                bottom = bottom - sizeOfMargin;
                                right = right + sizeOfMargin;
                                top = top + sizeOfMargin;
                                using (PtlRect mediaBox = new PtlRect(left, bottom, right, top))
                                {
                                    //MediaBoxの設定
                                    page.setMediaBox(mediaBox);
                                    //CropBoxの設定->MediaBoxと同じものを指定。
                                    page.setCropBox(mediaBox);
                                }
                            }
                        }

                        doc.save(outputFile);
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
