﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：印鑑（PDF）を矩形で指定した位置に貼り付けます。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddPdfStampOnReceipt
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AddPdfStampOnReceipt in-pdf-file out-pdf-file insert-stamp-pdf");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    //コマンドライン引数の取得
                    String insertPdfURI = args[2];

                    using (PtlPages pages = doc.getPages())
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("入力PDFのページコンテナが空");
                            return;
                        }
                        using (PtlPage page = pages.get(0))// 先頭ページの取得
                        {
                            // フォームの描画処理
                            drawPdfStamp(page, insertPdfURI);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static void drawPdfStamp(PtlPage page, String insertPdfURI)
        {
            using (PtlContent content = page.getContent())// 挿入先ページコンテントの取得
            using (PtlRect outputRect = new PtlRect(165, 55, 200, 75))// 出力矩形の設定
            using (PtlParamInput insertPdf = new PtlParamInput(insertPdfURI)) // 挿入PDF指定に使うパラメータクラス
            using (PtlPDFDocument doc2 = new PtlPDFDocument()) // 挿入PDFの実体
            {
                doc2.load(insertPdf);
                using (PtlPages pages2 = doc2.getPages())
                {
                    // ページコンテナが空かどうか
                    if (pages2.isEmpty())
                    {
                        Console.WriteLine("挿入するPDFのページコンテナが空");
                        return;
                    }
                    using (PtlPage pageInsert = pages2.get(0)) // 先頭ページの取得
                    {
                        // 指定ページの挿入（）
                        content.drawForm(outputRect, PtlContent.ALIGN.ALIGN_CENTER, pageInsert);
                    }
                }
            }
        }
    }
}
