﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：すべてのページの指定した位置にQRコードを挿入します。
  　　　配置矩形のみ、プログラム内で指定します。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;
namespace cookbook
{
    public class AddQRcodeOnAllPage
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AddQRcodeOnAllPage in-pdf-file out-pdf-file insert-image-file");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    //コマンドライン引数の取得
                    String imageURI = args[2];
                    int numPages = doc.getPageCount();
                    Console.WriteLine("ページ数：" + numPages);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }
                        using (PtlRect outputRect = setOutputRect())// 出力矩形の設定（setOutputRectを用いて初期化）
                        {
                            for (int i = 0; i < numPages; i++)
                            {
                                using (PtlPage page = pages.get(i))// ページの取得(パラメータindexは0が先頭のため1を引く)
                                using (PtlContent content = page.getContent())// ページコンテントの取得
                                using (PtlParamDrawImage paramDrawImage = new PtlParamDrawImage()) //画像の描画に使うパラメータクラス
                                using (PtlParamInput insertImage = new PtlParamInput(imageURI)) //画像指定に使うパラメータクラス
                                {
                                    //入力画像ストリームの設定
                                    paramDrawImage.setImageStream(insertImage);
                                    // 画像出力
                                    content.drawImage(outputRect, PtlContent.ALIGN.ALIGN_TOP_LEFT, paramDrawImage);
                                }
                            }
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static PtlRect setOutputRect()
        {
            float top, bottom, left, right;
            bool isValueOkay = false;
            PtlRect outputRect = new PtlRect();
            while (!isValueOkay)
            {
                Console.WriteLine("QRコードの配置矩形の各数値を入力してください。");
                Console.WriteLine("矩形の左上座標が配置の基準になり、");
                Console.WriteLine("そこから右下座標までの範囲を超えない範囲でQRコードが描画されます。");
                Console.Write("top (mm) : ");
                top = float.Parse(Console.ReadLine());
                Console.Write("left (mm) : ");
                left = float.Parse(Console.ReadLine());
                Console.Write("bottom (mm) : ");
                bottom = float.Parse(Console.ReadLine());
                Console.Write("right (mm) : ");
                right = float.Parse(Console.ReadLine());
                if (top < bottom) //不正矩形は再入力させる
                {
                    Console.WriteLine("topの値はbottomよりも大きい値を指定して再度入力してください。");
                    continue;
                }
                if (right < left) //不正矩形は再入力させる
                {
                    Console.WriteLine("rightの値はleftよりも大きい値を指定して再度入力してください。");
                    continue;
                }

                //矩形を正しく指定できた場合の処理
                isValueOkay = true;
                outputRect.setLeft(left);
                outputRect.setBottom(bottom);
                outputRect.setRight(right);
                outputRect.setTop(top);
            }
            return outputRect;
        }
    }
}
