﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：帳票PDF(領収書サンプル）に文字を記入します。
  　　　文字列を指定すれば、必要な文字列が挿入されるサンプルプログラムです。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddTextOnReceipt
    {
        public static void Main(String[] args)
        {
            if (args.Length < 8)
            {
                Console.WriteLine("usage: AddTextOnReceipt in-pdf-file out-pdf-file company-name postal-code adress1 adress2 phone-number fax-number");
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロードします。
                    doc.load(inputFile);
                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0))// ページの取得（先頭ページを指定）
                        using (PtlContent content = page.getContent())// ページコンテントの取得
                        using (PtlRect outputRect = new PtlRect())// 出力矩形の設定
                        using (PtlParamFont font = new PtlParamFont())// フォント
                        using (PtlParamWriteString writeStringParam = new PtlParamWriteString()) // 文字描画のパラメータクラス。今回は何も設定しない。
                        {
                            String companyName = args[2];
                            String postalCode = args[3];
                            String adress = args[4];
                            String adress2 = args[5];
                            String phoneNumber = args[6];
                            String faxNumber = args[7];

                            font.setName("MS-Gothic");  //フォントの設定
                                                        // 社名の記入
                            font.setSize(12.0f);
                            writeStringParam.setFont(font);
                            setRect(outputRect, 130, 58, 200, 65);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_BOTTOM_LEFT, companyName, writeStringParam);

                            // 郵便番号記入
                            font.setSize(10.0f);
                            setRect(outputRect, 129, 50.5f, 200, 58);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_LEFT, postalCode, writeStringParam);

                            // 住所記入1
                            font.setSize(12.0f);
                            setRect(outputRect, 125, 45, 200, 50.5f);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_BOTTOM_LEFT, adress, writeStringParam);
                            // 住所記入2
                            setRect(outputRect, 125, 40, 200, 45);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_TOP_LEFT, adress2, writeStringParam);

                            // 電話番号
                            font.setSize(10.0f);
                            setRect(outputRect, 145, 31.5f, 200, 38);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_TOP_LEFT, phoneNumber, writeStringParam);

                            // FAX番号
                            setRect(outputRect, 145, 24, 200, 31.5f);
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_TOP_LEFT, faxNumber, writeStringParam);

                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }


        public static PtlRect setRect(PtlRect outputRect, float left, float bottom, float right, float top)
        {
            outputRect.setLeft(left);
            outputRect.setBottom(bottom);
            outputRect.setRight(right);
            outputRect.setTop(top);

            return outputRect;
        }
    }
}
