﻿/*
  Antenna House PDF Tool API V6.0
  .Net Interface sample program

  概要：文字列の色を設定して１ページ目中央に描画するプログラム。

  Copyright (C) 2019- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/


using System;
using PdfTkNet;

namespace cookbook
{
    public class AddTextSetColor
    {
        public static void Main(String[] args)
        {
            if (args.Length < 3)
            {
                Console.WriteLine("usage: AddTextSetColor in-pdf-file out-pdf-file color-space");
                Console.WriteLine("color-space\n  0:無色 1:DeviceGray 2:DeviceRGB 3:DeviceCMYK");
                return;
            }

            int colorSpace = int.Parse(args[2]);
            switch (colorSpace)
            {
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                default:
                    Console.WriteLine("color-spaceには0から3の数を指定してください。");
                    Console.WriteLine("usage: AddTextSetColor in-pdf-file out-pdf-file color-space");
                    Console.WriteLine("color-space\n  0:無色 1:DeviceGray 2:DeviceRGB 3:DeviceCMYK");
                    return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {

                    // PDFファイルをロードします。
                    doc.load(inputFile);

                    using (PtlPages pages = doc.getPages()) //ページコンテナの取得
                    {
                        // ページコンテナが空かどうか
                        if (pages.isEmpty())
                        {
                            Console.WriteLine("ページコンテナが空");
                            return;
                        }

                        using (PtlPage page = pages.get(0)) // ページの取得(先頭ページを取得)
                        using (PtlContent content = page.getContent()) // ページコンテントの取得
                        using (PtlRect outputRect = page.getViewBox()) // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                        using (PtlParamWriteString writeStringParam = new PtlParamWriteString()) // 文字描画のパラメータクラス
                                                                                                 // 色表現用のクラスを作成
                        using (PtlColorNone colorNone = new PtlColorNone()) // 無色を表現したクラス
                        using (PtlColorDeviceGray colorGray = new PtlColorDeviceGray()) // DeviceGray色空間で色表現したクラス
                        using (PtlColorDeviceRGB colorRGB = new PtlColorDeviceRGB()) //DeviceRGB色空間で色表現したクラス
                        using (PtlColorDeviceCMYK colorCMYK = new PtlColorDeviceCMYK()) //DeviceCMYK色空間で色表現したクラス
                        {

                            switch (colorSpace)
                            {
                                case 0: //無色
                                    Console.WriteLine("無色が指定されました。無色で文字を描画します。");
                                    writeStringParam.setTextColor(colorNone);
                                    break;
                                case 1: //DeviceGray
                                    Console.WriteLine("グレースケール値を0.0～1.0の範囲で入力してください。0.0が黒、1.0が白。");
                                    colorGray.setGray(setValue());
                                    writeStringParam.setTextColor(colorGray);
                                    break;
                                case 2: //DeviceRGB
                                    Console.WriteLine("RGBの各要素の値を0.0～1.0の範囲で入力してください。0.0が要素なし、1.0が要素の最大");
                                    Console.Write("赤：");
                                    colorRGB.setR(setValue());
                                    Console.Write("緑：");
                                    colorRGB.setG(setValue());
                                    Console.Write("青：");
                                    colorRGB.setB(setValue());
                                    writeStringParam.setTextColor(colorRGB);
                                    break;
                                case 3: //DeviceCMYK
                                    Console.WriteLine("CYMKの各要素の値を0.0～1.0の範囲で入力してください。0.0が要素なし、1.0が要素の最大");
                                    Console.Write("シアン：");
                                    colorCMYK.setC(setValue());
                                    Console.Write("マゼンタ：");
                                    colorCMYK.setM(setValue());
                                    Console.Write("黄：");
                                    colorCMYK.setY(setValue());
                                    Console.Write("色調(黒)：");
                                    colorCMYK.setK(setValue());
                                    writeStringParam.setTextColor(colorCMYK);
                                    break;
                            }

                            // 文字列出力 (中央に文字列を作成)
                            content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                                "writeString Test : set color", writeStringParam);
                        }
                    }

                    // ファイルに保存します。
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static float setValue()
        {
            float value = -1.0f;
            bool isValueOk = false;
            while (!isValueOk)
            {
                value = float.Parse(Console.ReadLine());
                if ((value < 0) || (1.0f < value))
                {
                    Console.WriteLine("0.0から1.0の範囲で再度値を設定してください。");
                }
                else
                {
                    isValueOk = true;
                }
            }
            return value;

        }
    }
}
